package questao.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.ComplementoVouFDTO;
import dao.DAOBase;

public class ComplementoVouFDAO extends DAOBase{
	
    private static final String SQL_ALTERARQUESTAOVouF = "update bdqVouF set comentariocerto = ?, comentarioerrado = ? where idquestao = ?";
	private static final String SQL_DELETARQUESTAOVouF = "delete from bdqVouF where idquestao = ?";
	private static final String SQL_CADASTRARQUESTAOVouF = "insert into bdqVouF values (?,?,?,?)";
	private static final String SQL_LISTARTODASQUESTOESVouF = "select * from bdqVouF order by idquestao";
	private static final String SQL_BUSCARQUESTAOVouF = "select * from bdqVouF where (idquestao = ?)";
	
	public Collection listarTodosComplementos() throws SQLException{
		Statement stm = this.getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASQUESTOESVouF);
		Collection col = new ArrayList();
		ComplementoVouFDTO dto;
		while(rs.next()){
			dto = new ComplementoVouFDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarComplemento(ComplementoVouFDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_CADASTRARQUESTAOVouF);
		ps.setInt(1,dto.getIdQuestao().intValue());
		ps.setString(2,dto.getResposta());
		ps.setString(3,dto.getComentarioCerto());
		ps.setString(4,dto.getComentarioErrado());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirComplemento(Integer idQuestao) throws SQLException {

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_DELETARQUESTAOVouF);
		ps.setInt(1,idQuestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public ComplementoVouFDTO buscarComplemento(Integer idQuestao) throws SQLException {
		ComplementoVouFDTO dto = new ComplementoVouFDTO();

		PreparedStatement ps = this.getConnection().prepareStatement(SQL_BUSCARQUESTAOVouF);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public void alterarComplemento(ComplementoVouFDTO dto) throws SQLException {
		PreparedStatement ps = this.getConnection().prepareStatement(SQL_ALTERARQUESTAOVouF);
		
		ps.setString(1,dto.getComentarioCerto());
		ps.setString(2,dto.getComentarioErrado());
		ps.setInt(3,dto.getIdQuestao().intValue());
		
		ps.executeUpdate();
		ps.close();
	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
	public void putDto(ResultSet rs, ComplementoVouFDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("idQuestao")));
		dto.setComentarioCerto(rs.getString("comentarioCerto"));
		dto.setComentarioErrado(rs.getString("comentarioErrado"));
		dto.setResposta(rs.getString("resposta"));
	}

}
