package questao.dao;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.ListaDTO;
import questao.slave.UtilDate;
import questao.validacao.apoio.ApoioLista;
import dao.DAOBase;

public class ListaDAO extends DAOBase{
	
    private static final String SQL_ALTERARLISTA = "update bdqLista set titulolista = ?, categoria = ?, quantidadequestoes = ?, chaveacesso = ? where idlista = ?";
	private static final String SQL_DELETARLISTA = "delete from bdqLista where idlista = ?";
	private static final String SQL_CADASTRARLISTA = "insert into bdqLista values (?,?,?,?,?,?,?)";
	private static final String SQL_LISTARTODASLISTA = "select * from bdqLista order by dtcriacao, titulolista";
	private static final String SQL_BUSCARLISTA = "select * from bdqLista where (idlista = ?)";
	private static final String SQL_BUSCARULTIMALISTA = "select max(idlista) from bdqLista";
	
	public Collection listarTodasListas() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASLISTA);
		Collection col = new ArrayList();
		ListaDTO dto;
		while(rs.next()){
			dto = new ListaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarLista(ListaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARLISTA);
		ps.setInt(1,0);
		ps.setInt(2,dto.getChavePessoaProfessor().intValue());
		ps.setString(3,dto.getTituloLista());
		ps.setString(4,dto.getCategoria());
		ps.setInt(5,dto.getQuantidadeQuestoes().intValue());
		ps.setDate(6, new java.sql.Date(dto.getDtCriacao().getTime()));
		ps.setString(7,dto.getChaveAcesso());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirLista(Integer idLista) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARLISTA);
		ps.setInt(1,idLista.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public Integer buscarUltimoIdLista() throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARULTIMALISTA);
		ResultSet rs = ps.executeQuery();
		Integer idLista = null;
		if(rs.next())
			idLista=new Integer(rs.getString(1));
		rs.close();
		ps.close();
		return idLista;
		
	}
			
	public ListaDTO buscarLista(Integer idLista) throws SQLException {
		ListaDTO dto = new ListaDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARLISTA);
		ps.setInt(1,idLista.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDto(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public ApoioLista buscarListaApoioLista(Integer idLista) throws SQLException {
		ApoioLista apoioLista = new ApoioLista();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARLISTA);
		ps.setInt(1,idLista.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDtoApoioLista(rs,apoioLista);
		rs.close();
		ps.close();
		return apoioLista;
		
	}
	
	
	public void alterarLista(ListaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARLISTA);
		
		ps.setString(1,dto.getTituloLista());
		ps.setString(2,dto.getCategoria());
		ps.setInt(3,dto.getQuantidadeQuestoes().intValue());
		ps.setString(4,dto.getChaveAcesso());
		ps.setInt(5,dto.getIdLista().intValue());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarListaPorTitulo(String titulo) throws SQLException {
		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM bdqLista WHERE TITULOLISTA LIKE '%"+titulo+"%' ORDER BY TITULOLISTA;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARLISTAPORTITULO);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ListaDTO dto;
		while(rs.next()){
			dto = new ListaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	
//	public Collection buscarListaDeQuestoes(QuestaoDTO dtoTemp) throws SQLException {
//		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoes(dtoTemp);
//		PreparedStatement ps = con.prepareStatement(sql_buscarListaDeQuestoes);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
//	private String montaSelectListaDeQuestoes(QuestaoDTO dtoTemp) {
//		boolean temParteWhere = false;
//		StringBuffer select = new StringBuffer();
//		select.append("SELECT * FROM BDQQUESTAO questao ");
//		
//		//Tipo de questao (Outra tabela)
//		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idQuestao = "+dtoTemp.getTipoQuestao()+" ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.idQuestao = "+dtoTemp.getTipoQuestao()+" ");
//			}
//		}
//		
//		//Enunciado
//		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
//			}
//		}
//		
//		//Dificuldade
//		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
//			}
//		}
//		
//		//Categoria
//		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.categoria ='"+dtoTemp.getCategoria()+"' ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.categoria ='"+dtoTemp.getCategoria()+"' ");
//			}
//		}
//		
//		//Disciplina
//		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//			}
//		}
//		
//		//Conteudo
//		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//			}
//		}
//		return select.toString();
//	}

	public void putDto(ResultSet rs, ListaDTO dto) throws SQLException{
		dto.setIdLista(new Integer(rs.getString("idLista")));
		dto.setChaveAcesso(rs.getString("chavePessoaProfessor"));
		dto.setTituloLista(rs.getString("tituloLista"));
		dto.setCategoria(rs.getString("categoria"));
		dto.setQuantidadeQuestoes(new Integer(rs.getString("quantidadeQuestoes")));
		dto.setDtCriacao(UtilDate.getSqlDateComoDate(rs.getDate("dtCriacao")));
		dto.setChaveAcesso(rs.getString("chaveAcesso"));
	}
	
	public void putDtoApoioLista(ResultSet rs, ApoioLista dto) throws SQLException{
		dto.setCategoria(rs.getString("categoria"));
		dto.setQuantidadeQuestoes(rs.getString("quantidadeQuestoes"));
		dto.setTituloLista(rs.getString("tituloLista"));
		dto.setIdLista(rs.getString("idLista"));
	}

}
