package questao.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import questao.dto.ListaDTO;
import questao.dto.ListaTurmaDTO;
import questao.slave.UtilDate;
import dao.DAOBase;
import dto.TurmaDTO;

public class ListaTurmaDAO extends DAOBase{
	private Connection con;
	public void setConnection(Connection con) {
		this.con = con;
	}
	
//    private static final String SQL_ALTERARLISTA = "UPDATE BDQLISTA set TITULOLISTA = ?, CATEGORIA = ?, QUANTIDADEQUESTOES = ?, CHAVEACESSO = ? WHERE IDLISTA = ?";
//	private static final String SQL_DELETARQUESTAODALISTA = "delete from bdqLista_Questao where idlista = ? and idquestao = ?";
	private static final String SQL_DELETARLISTATURMA = "delete from bdqLista_Turma where idlista = ? and codigoTurma = ? and codigoCurso = ? and idDisciplina = ? and semestre = ? and ano = ?";
//	private static final String SQL_CADASTRARLISTA = "insert into bdqLista_Questao values (?,?)";
	private static final String SQL_CADASTRARLISTATURMA = "insert into bdqLista_Turma values (?,?,?,?,?,?,?,?)";
//	private static final String SQL_LISTARTODASLISTA = "SELECT * FROM BDQLISTA ORDER BY dtCriacao, tituloLista";
//	private static final String SQL_BUSCARLISTA = "SELECT * FROM BDQLISTA WHERE (IDLISTA = ?)";
//	private static final String SQL_BUSCARULTIMALISTA = "SELECT MAX(IDLISTA) FROM BDQLISTA";
	
//	public Collection listarTodasListas() throws SQLException{
//		Statement stm = con.createStatement();
//		ResultSet rs = stm.executeQuery(SQL_LISTARTODASLISTA);
//		Collection col = new ArrayList();
//		ListaDTO dto;
//		while(rs.next()){
//			dto = new ListaDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
//	public void cadastrarLista(Integer idLista, Integer idQuestao) throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_CADASTRARLISTA);
//		ps.setInt(1,idLista.intValue());
//		ps.setInt(2,idQuestao.intValue());
//		
//		ps.executeUpdate();
//		ps.close();
//	}
	
	public void cadastrarListaTurma(TurmaDTO dto, Integer idLista, Date dtLimiteEntrega, Date horarioLimiteEntrega) throws SQLException {
		PreparedStatement ps = con.prepareStatement(SQL_CADASTRARLISTATURMA);
		ps.setInt(1,idLista.intValue());
		ps.setString(2,dto.getCodigoTurma());
		ps.setInt(3,dto.getCodigoCurso().intValue());
		ps.setInt(4,dto.getIdDisciplina().intValue());
		ps.setInt(5,dto.getAno().intValue());
		ps.setString(6,dto.getSemestre());
		ps.setDate(7, UtilDate.getDateComoSqlDate(dtLimiteEntrega));
		ps.setTime(8, UtilDate.getDateComoSqlTime(horarioLimiteEntrega));
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarListaPorTitulo(TurmaDTO dtoTurma) throws ParseException, SQLException{
		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM bdqLista lista inner join bdqLista_Turma rel on rel.idLista = lista.idLista WHERE rel.codigoturma = ? and rel.codigocurso = ? and rel.iddisciplina = ? and rel.ano = ? and rel.semestre = ?;";
		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTAPORTITULO);
		ps.setString(1,dtoTurma.getCodigoTurma());
		ps.setInt(2,dtoTurma.getCodigoCurso().intValue());
		ps.setInt(3,dtoTurma.getIdDisciplina().intValue());
		ps.setInt(4,dtoTurma.getAno().intValue());
		ps.setString(5,dtoTurma.getSemestre());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ListaTurmaDTO dto;
		while(rs.next()){
			dto = new ListaTurmaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public ListaTurmaDTO buscarListaDaTurmaPorId(String idLista, TurmaDTO dtoTurma) throws ParseException, SQLException{
		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM bdqLista lista inner join bdqLista_Turma rel on rel.idLista = lista.idLista WHERE lista.idLista = ? and rel.codigoturma = ? and rel.codigocurso = ? and rel.iddisciplina = ? and rel.ano = ? and rel.semestre = ?;";
		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTAPORTITULO);
		ps.setString(1,idLista);
		ps.setString(2,dtoTurma.getCodigoTurma());
		ps.setInt(3,dtoTurma.getCodigoCurso().intValue());
		ps.setInt(4,dtoTurma.getIdDisciplina().intValue());
		ps.setInt(5,dtoTurma.getAno().intValue());
		ps.setString(6,dtoTurma.getSemestre());
		ResultSet rs = ps.executeQuery();
		ListaTurmaDTO dto = null;
		while(rs.next()){
			dto = new ListaTurmaDTO();
			putDto(rs,dto);
		}
		rs.close();
		return dto;
	}
	
	public Collection buscarTodasListaETurmas() throws ParseException, SQLException{
		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM bdqLista lista inner join bdqLista_Turma rel on rel.idLista = lista.idLista;";
		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTAPORTITULO);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ListaTurmaDTO dto;
		while(rs.next()){
			dto = new ListaTurmaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public Collection buscarTodasListaETurmasEChaveAluno(String chaveAluno) throws ParseException, SQLException{
		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM bdqLista lista " +
				"inner join bdqLista_Turma rel on rel.idLista = lista.idLista " +
				"inner join maiorTurma_Aluno relTurma on relTurma.codigoTurma=rel.codigoTurma " +
					"and relTurma.codigoCurso=rel.codigoCurso " +
					"and relTurma.idDisciplina=rel.idDisciplina " +
					"and relTurma.ano=rel.ano " +
					"and relTurma.semestre=rel.semestre " +
				"where relTurma.chavePessoaAluno=?;";
		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTAPORTITULO);
		ps.setInt(1, Integer.parseInt(chaveAluno));
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ListaTurmaDTO dto;
		while(rs.next()){
			dto = new ListaTurmaDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public ListaTurmaDTO buscaDataLimiteParaLista(ListaDTO lista, String chaveAluno) throws ParseException, SQLException{
		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM bdqLista lista " +
				"inner join bdqLista_Turma rel on rel.idLista = lista.idLista " +
				"inner join maiorTurma_Aluno relTurma on relTurma.codigoTurma=rel.codigoTurma " +
					"and relTurma.codigoCurso=rel.codigoCurso " +
					"and relTurma.idDisciplina=rel.idDisciplina " +
					"and relTurma.ano=rel.ano " +
					"and relTurma.semestre=rel.semestre " +
				"where (relTurma.chavePessoaAluno=? or lista.chavePessoaProfessor=?) and lista.idLista = ? group by lista.idLista;";
		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTAPORTITULO);
		ps.setInt(1, Integer.parseInt(chaveAluno));
		ps.setInt(2, Integer.parseInt(chaveAluno));
		ps.setInt(3, lista.getIdLista().intValue());
		ResultSet rs = ps.executeQuery();
		ListaTurmaDTO dto=null;
		if(rs.next()){
			dto = new ListaTurmaDTO();
			putDto(rs,dto);
		}
		rs.close();
		return dto;
	}

//	public void excluirQuestaoDaLista(Integer idLista, Integer idQuestao) throws SQLException {
//
//		PreparedStatement ps = con.prepareStatement(SQL_DELETARQUESTAODALISTA);
//		ps.setInt(1,idLista.intValue());
//		ps.setInt(2,idQuestao.intValue());
//		ps.executeUpdate();
//		ps.close();
//	}
//	
	public void excluirListaDaTurma(Integer idLista, TurmaDTO turma) throws SQLException {

		PreparedStatement ps = con.prepareStatement(SQL_DELETARLISTATURMA);
		ps.setInt(1,idLista.intValue());
		ps.setString(2,turma.getCodigoTurma());
		ps.setInt(3,turma.getCodigoCurso().intValue());
		ps.setInt(4,turma.getIdDisciplina().intValue());
		ps.setString(5,turma.getSemestre());
		ps.setInt(6,turma.getAno().intValue());
		ps.executeUpdate();
		ps.close();
	}
	
//	public Integer buscarUltimoIdLista() throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARULTIMALISTA);
//		ResultSet rs = ps.executeQuery();
//		Integer idLista = null;
//		if(rs.next())
//			idLista=new Integer(rs.getString(1));
//		rs.close();
//		ps.close();
//		return idLista;
//		
//	}
			
//	public ListaDTO buscarLista(Integer idLista) throws SQLException {
//		ListaDTO dto = new ListaDTO();
//
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTA);
//		ps.setInt(1,idLista.intValue());
//		ResultSet rs = ps.executeQuery();
//		if(rs.next())
//			putDto(rs,dto);
//		rs.close();
//		ps.close();
//		return dto;
//		
//	}
	
//	public void alterarLista(ListaDTO dto) throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_ALTERARLISTA);
//		
//		ps.setString(1,dto.getTituloLista());
//		ps.setString(2,dto.getCategoria());
//		ps.setInt(3,dto.getQuantidadeQuestoes().intValue());
//		ps.setString(4,dto.getChaveAcesso());
//		ps.setInt(5,dto.getIdLista().intValue());
//		
//		ps.executeUpdate();
//		ps.close();
//	}
	
//	public Collection buscarListaPorTitulo(String titulo) throws SQLException {
//		String SQL_BUSCARLISTAPORTITULO = "SELECT * FROM BDQLISTA WHERE TITULOLISTA LIKE '%"+titulo+"%' ORDER BY TITULO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARLISTAPORTITULO);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		ListaDTO dto;
//		while(rs.next()){
//			dto = new ListaDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	

//	public Collection buscarListaDeQuestoes(QuestaoDTO dtoTemp) throws SQLException {
//		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoes(dtoTemp);
//		PreparedStatement ps = con.prepareStatement(sql_buscarListaDeQuestoes);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
//	private String montaSelectListaDeQuestoes(QuestaoDTO dtoTemp) {
//		boolean temParteWhere = false;
//		StringBuffer select = new StringBuffer();
//		select.append("SELECT * FROM BDQQUESTAO questao ");
//		
//		//Tipo de questao (Outra tabela)
//		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idQuestao = "+dtoTemp.getTipoQuestao()+" ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.idQuestao = "+dtoTemp.getTipoQuestao()+" ");
//			}
//		}
//		
//		//Enunciado
//		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
//			}
//		}
//		
//		//Dificuldade
//		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
//			}
//		}
//		
//		//Categoria
//		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.categoria ='"+dtoTemp.getCategoria()+"' ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.categoria ='"+dtoTemp.getCategoria()+"' ");
//			}
//		}
//		
//		//Disciplina
//		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//			}
//		}
//		
//		//Conteudo
//		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//				temParteWhere=true;
//			}else{
//				select.append(" and questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//			}
//		}
//		return select.toString();
//	}

	public void putDto(ResultSet rs, ListaTurmaDTO dto) throws ParseException, SQLException{
		dto.setIdLista(new Integer(rs.getString("idLista")));
		dto.setChaveAcesso(rs.getString("chavePessoaProfessor"));
		dto.setTituloLista(rs.getString("tituloLista"));
		dto.setCategoria(rs.getString("categoria"));
		dto.setQuantidadeQuestoes(new Integer(rs.getString("quantidadeQuestoes")));
		dto.setDtCriacao(new Date(rs.getDate("dtCriacao").getTime()));
		dto.setChaveAcesso(rs.getString("chaveAcesso"));
		dto.setCodigoTurma(rs.getString("codigoTurma"));
		dto.setCodigoCurso(new Integer(rs.getString("codigoCurso")));
		dto.setIdDisciplina(new Integer(rs.getString("idDisciplina")));
		dto.setAno(new Integer(rs.getString("ano")));
		dto.setSemestre(rs.getString("semestre"));
		
		if(rs.getDate("dtLimiteEntrega")!=null)
			dto.setDtLimiteEntrega(new Date(rs.getDate("dtLimiteEntrega").getTime()));
		
		if(rs.getTime("horarioLimiteEntrega")!=null)
			dto.setHorarioLimiteEntrega(UtilDate.getDataHora24(UtilDate.getDataComoString(rs.getDate("dtLimiteEntrega"))+" "+rs.getString("horarioLimiteEntrega")));
	}

}
