package questao.dao;

import java.sql.*;
import java.util.*;

import questao.dto.ListaDTO;
import questao.dto.QuestaoDTO;
import questao.slave.DominioCategoriaQuestao;
import questao.slave.UtilDate;
import questao.validacao.apoio.ApoioQuestao;
import DominioDiaDaSemana.Dominio;
import dao.DAOBase;

public class QuestaoDAO extends DAOBase{
		
    private static final String SQL_ALTERARQUESTAO = "update bdqQuestao set iddisciplina = ?, idconteudo = ?, enunciado = ?, tipoquestao = ?, dificuldade = ?, categoria = ?, tempo = ? where idquestao = ?";
	private static final String SQL_DELETARQUESTAO = "delete from bdqQuestao where idquestao = ?";
	private static final String SQL_CADASTRARQUESTAO = "insert into bdqQuestao values (?,?,?,?,?,?,?,?,?,?)";
	private static final String SQL_LISTARTODASQUESTOES = "select * from bdqQuestao order by idDisciplina,enunciado";
	private static final String SQL_BUSCARQUESTAO = "select * from bdqQuestao questao inner join maiorDisciplina disciplina on disciplina.idDisciplina=questao.idDisciplina inner join maiorConteudo conteudo on conteudo.idConteudo=questao.idConteudo where questao.idquestao = ? order by disciplina.nomeDisciplina,questao.enunciado";
	private static final String SQL_BUSCARQUESTAOAPOIO = "select * from bdqQuestao questao inner join maiorPessoa pessoa on pessoa.chavepessoa=questao.chavepessoa inner join maiorConteudo conteudo on conteudo.idconteudo=questao.idconteudo inner join maiorDisciplina disciplina on disciplina.iddisciplina=questao.iddisciplina where (idquestao = ?) order by disciplina.nomeDisciplina,questao.enunciado";
	private static final String SQL_BUSCARULTIMAQUESTAO = "select max(idquestao) from bdqQuestao";
	
	public Collection listarTodasQuestoes() throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTARTODASQUESTOES);
		Collection col = new ArrayList();
		QuestaoDTO dto;
		while(rs.next()){
			dto = new QuestaoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public void cadastrarQuestao(QuestaoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARQUESTAO);
		ps.setInt(1,0);
		ps.setInt(2,dto.getIdDisciplina().intValue());
		ps.setInt(3,dto.getIdConteudo().intValue());
		ps.setInt(4,dto.getChavePessoa().intValue());
		ps.setString(5,dto.getEnunciado());
		ps.setString(6,dto.getTipoQuestao());
		ps.setString(7,dto.getDificuldade());
		ps.setString(8,dto.getCategoria());
		ps.setInt(9,dto.getTempo().intValue());
		ps.setDate(10, new java.sql.Date(dto.getDtcriacao().getTime()));
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirQuestao(Integer idQuestao) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARQUESTAO);
		ps.setInt(1,idQuestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public Integer buscarUltimoIdQuestao() throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARULTIMAQUESTAO);
		ResultSet rs = ps.executeQuery();
		Integer idQuestao = null;
		if(rs.next())
			idQuestao=new Integer(rs.getString(1));
		rs.close();
		ps.close();
		return idQuestao;
		
	}
			
	public QuestaoDTO buscarQuestao(Integer idQuestao) throws SQLException {
		QuestaoDTO dto = new QuestaoDTO();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARQUESTAO);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDtoResponder(rs,dto);
		rs.close();
		ps.close();
		return dto;
		
	}
	
	public ApoioQuestao buscarQuestaoApoio(Integer idQuestao) throws SQLException {
		ApoioQuestao apoio = new ApoioQuestao();

		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARQUESTAOAPOIO);
		ps.setInt(1,idQuestao.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next())
			putDtoApoio(rs,apoio);
		rs.close();
		ps.close();
		return apoio;
		
	}
	
	public static void main(String[] args){
		QuestaoDAO dao = new QuestaoDAO();
		try {
			Integer id = dao.buscarUltimoIdQuestao();
			System.out.println(id);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void alterarQuestao(QuestaoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARQUESTAO);
		
		ps.setInt(1,dto.getIdDisciplina().intValue());
		ps.setInt(2,dto.getIdConteudo().intValue());
		ps.setString(3,dto.getEnunciado());
		ps.setString(4,dto.getTipoQuestao());
		ps.setString(5,dto.getDificuldade());
		ps.setString(6,dto.getCategoria());
		ps.setInt(7,dto.getTempo().intValue());
		ps.setInt(8,dto.getIdQuestao().intValue());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "select * from bdqQuestao where enunciado like '%"+enunciado+"%' order by idDisciplina, enunciado;";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		QuestaoDTO dto;
		while(rs.next()){
			dto = new QuestaoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	

	public List buscarListaDeQuestoes(QuestaoDTO dtoTemp) throws SQLException {
		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoes(dtoTemp);
		PreparedStatement ps = getConnection().prepareStatement(sql_buscarListaDeQuestoes);
		ResultSet rs = ps.executeQuery();
		List col = new ArrayList();
		QuestaoDTO dto;
		while(rs.next()){
			dto = new QuestaoDTO();
			putDtoResponder(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public int buscarQuantidadeListaDeQuestoes(QuestaoDTO dtoTemp) throws SQLException {
		String sql_buscarListaDeQuestoes = montaSelectListaQuantidadeDeQuestoes(dtoTemp);
		PreparedStatement ps = getConnection().prepareStatement(sql_buscarListaDeQuestoes);
		ResultSet rs = ps.executeQuery();
		int qtd=0;
		if(rs.next()){
			qtd=rs.getInt(1);
		}
		rs.close();
		return qtd;
	}
	
	public List buscarListaDeQuestoes(QuestaoDTO dtoTemp, Integer perfil, Integer chavePessoa) throws SQLException {
		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoes(dtoTemp, perfil, chavePessoa);
		System.out.println(sql_buscarListaDeQuestoes);
		PreparedStatement ps = getConnection().prepareStatement(sql_buscarListaDeQuestoes);
		
		ResultSet rs = ps.executeQuery();
		List col = new ArrayList();
		QuestaoDTO dto;
		while(rs.next()){
			dto = new QuestaoDTO();
			putDtoResponder(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public List buscarListaDeQuestoesApoioQuestao(QuestaoDTO dtoTemp) throws SQLException {
		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoesApoioQuestao(dtoTemp);
		PreparedStatement ps = getConnection().prepareStatement(sql_buscarListaDeQuestoes);
		ResultSet rs = ps.executeQuery();
		List col = new ArrayList();
		ApoioQuestao apoio;
		while(rs.next()){
			apoio = new ApoioQuestao();
			putDtoApoio(rs,apoio);
			col.add(apoio);
		}
		rs.close();
		return col;
	}
	
	public List buscarListaDeQuestoes(ListaDTO dtoTemp, Integer chavePessoa) throws SQLException {
		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoesParaReponderLista();
		PreparedStatement ps = getConnection().prepareStatement(sql_buscarListaDeQuestoes);
		ps.setInt(1,dtoTemp.getIdLista().intValue());
		ps.setInt(2,chavePessoa.intValue());
		ps.setInt(3,dtoTemp.getIdLista().intValue());
		ps.setString(4,slave.Data.getDataInicioDoSemestre());
		ResultSet rs = ps.executeQuery();
		List col = new ArrayList();
		QuestaoDTO dto;
		while(rs.next()){
			dto = new QuestaoDTO();
			putDtoResponder(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	private String montaSelectListaDeQuestoesParaReponderLista() {
		StringBuffer select = new StringBuffer();
			select.append("select * from bdqQuestao questao ");
			select.append("inner join bdqLista_Questao rel on questao.idquestao=rel.idquestao ");
			select.append("inner join maiorDisciplina disciplina on questao.idDisciplina=disciplina.idDisciplina ");
			select.append("inner join maiorConteudo conteudo on questao.idConteudo=conteudo.idConteudo ");
			select.append("where rel.idlista=? ");
			select.append("and questao.idquestao not in (select idquestao from bdqAluno_RespostaLista where chavepessoa=?  and idLista=? and dtSolucao >= ?) ");
			
			System.out.println(select.toString());
		return select.toString();
	}

	private String montaSelectListaDeQuestoes(QuestaoDTO dtoTemp) {
		boolean temParteWhere = false;
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join maiorDisciplina disciplina on questao.idDisciplina=disciplina.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on questao.idConteudo=conteudo.idConteudo ");
		
		//Tipo de questao (Outra tabela)
		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
			if(!temParteWhere){
				select.append(" where questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
			}
		}
		
		//Enunciado
		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
			if(!temParteWhere){
				select.append(" where questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
			}
		}
		
		//Dificuldade
		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
			if(!temParteWhere){
				select.append(" where questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
			}
		}
		
		//Categoria
		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
			if(!temParteWhere){
				select.append(" where questao.categoria ='"+dtoTemp.getCategoria()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria ='"+dtoTemp.getCategoria()+"' ");
			}
		}else{
			if(!temParteWhere){
				select.append(" where questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
			}
			
		}
		
		//Disciplina
		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
			if(!temParteWhere){
				select.append(" where questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
			}
		}
		
		//Conteudo
		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
			if(!temParteWhere){
				select.append(" where questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
			}
		}
		select.append(" order by disciplina.nomeDisciplina,questao.enunciado ");
		return select.toString();
	}
	
	private String montaSelectListaQuantidadeDeQuestoes(QuestaoDTO dtoTemp) {
		boolean temParteWhere = false;
		StringBuffer select = new StringBuffer();
		select.append("select count(questao.idQuestao) from bdqQuestao questao ");
		select.append("inner join maiorDisciplina disciplina on questao.idDisciplina=disciplina.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on questao.idConteudo=conteudo.idConteudo ");
		
		//Tipo de questao (Outra tabela)
		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
			if(!temParteWhere){
				select.append(" where questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
			}
		}
		
		//Enunciado
		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
			if(!temParteWhere){
				select.append(" where questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
			}
		}
		
		//Dificuldade
		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
			if(!temParteWhere){
				select.append(" where questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
			}
		}
		
		//Categoria
		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
			if(!temParteWhere){
				select.append(" where questao.categoria ='"+dtoTemp.getCategoria()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria ='"+dtoTemp.getCategoria()+"' ");
			}
		}else{
			if(!temParteWhere){
				select.append(" where questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
			}
			
		}
		
		//Disciplina
		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
			if(!temParteWhere){
				select.append(" where questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
			}
		}
		
		//Conteudo
		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
			if(!temParteWhere){
				select.append(" where questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
			}
		}
		select.append(" order by disciplina.nomeDisciplina,questao.enunciado ");
		return select.toString();
	}
	
	private String montaSelectListaDeQuestoes(QuestaoDTO dtoTemp, Integer perfil, Integer chavePessoa) {
		boolean temParteWhere = false;
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join maiorDisciplina disciplina on questao.idDisciplina=disciplina.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on questao.idConteudo=conteudo.idConteudo ");
		
		if(perfil.intValue()==Dominio.getProfessor().intValue()){
			select.append("inner join maiorTurma turma on turma.idDisciplina=disciplina.idDisciplina ");
			select.append("inner join maiorProfessor professor on professor.chavePessoa=turma.chavePessoaProfessor ");
			select.append("inner join maiorPessoa pessoa on professor.chavePessoa=pessoa.chavePessoa ");
		}
		else{
			select.append("inner join maiorTurma_Aluno turma on turma.idDisciplina=disciplina.idDisciplina ");
			select.append("inner join maiorAluno aluno on aluno.chavePessoa=turma.chavePessoaAluno ");
			select.append("inner join maiorPessoa pessoa on aluno.chavePessoa=pessoa.chavePessoa ");
		}
		
		//Tipo de questao (Outra tabela)
		if(chavePessoa!=null){
			if(!temParteWhere){
				select.append(" where pessoa.chavePessoa = "+chavePessoa.toString()+" ");
				temParteWhere=true;
			}else{
				select.append(" and pessoa.chavePessoa = "+chavePessoa.toString()+" ");
			}
		}
		
		//Tipo de questao (Outra tabela)
		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
			if(!temParteWhere){
				select.append(" where questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
			}
		}
		
		//Enunciado
		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
			if(!temParteWhere){
				select.append(" where questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
			}
		}
		
		//Dificuldade
		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
			if(!temParteWhere){
				select.append(" where questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
			}
		}
		
		//Categoria
		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
			if(!temParteWhere){
				select.append(" where questao.categoria ='"+dtoTemp.getCategoria()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria ='"+dtoTemp.getCategoria()+"' ");
			}
		}else{
			if(!temParteWhere){
				select.append(" where questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
			}
			
		}
		
		//Disciplina
		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
			if(!temParteWhere){
				select.append(" where questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
			}
		}
		
		//Conteudo
		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
			if(!temParteWhere){
				select.append(" where questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
			}
		}
		select.append(" order by disciplina.nomeDisciplina,questao.enunciado ");
		return select.toString();
	}
	
	private String montaSelectListaDeQuestoesApoioQuestao(QuestaoDTO dtoTemp) {
		boolean temParteWhere = false;
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join maiorPessoa pessoa on pessoa.chavepessoa=questao.chavepessoa ");
		select.append("inner join maiorConteudo conteudo on conteudo.idconteudo=questao.idconteudo ");
		select.append("inner join maiorDisciplina disciplina on disciplina.iddisciplina=questao.iddisciplina ");
		select.append("inner join maiorCurso_Disciplina curso on curso.iddisciplina=disciplina.iddisciplina ");
		
		//Professor
		if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getProfessor().intValue()){
			select.append("inner join maiorProfessor professor on professor.codigoCursoVinculo=curso.codigoCurso ");
			if(!temParteWhere){
				select.append(" where professor.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
				temParteWhere=true;
			}else{
				select.append(" and professor.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			}
		}
		
		//Aluno
		if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getAluno().intValue()){
			select.append("inner join maiorAluno aluno on aluno.codigoCurso=curso.codigoCurso ");
			if(!temParteWhere){
				select.append(" where aluno.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
				temParteWhere=true;
			}else{
				select.append(" and aluno.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			}
		}
		
		//Diretor
		if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getDiretor().intValue()){
			select.append("inner join maiorDiretor diretor on diretor.codigoCurso=curso.codigoCurso ");
			if(!temParteWhere){
				select.append(" where diretor.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
				temParteWhere=true;
			}else{
				select.append(" and diretor.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			}
		}
		
		//Monitor
		if(getLoginUsuarioDTOLogado().getPerfil().intValue()==Dominio.getMonitor().intValue()){
			select.append("inner join maiorMonitor monitor on monitor.idDisciplina=disciplina.idDisciplina ");
			if(!temParteWhere){
				select.append(" where monitor.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
				temParteWhere=true;
			}else{
				select.append(" and monitor.chavePessoa = "+getLoginUsuarioDTOLogado().getChavePessoa()+" ");
			}
		}
		
		
		//Tipo de questao (Outra tabela)
		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
			if(!temParteWhere){
				select.append(" where questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.tipoquestao = "+dtoTemp.getTipoQuestao()+" ");
			}
		}
		
		//Enunciado
		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
			if(!temParteWhere){
				select.append(" where questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.enunciado like '%"+dtoTemp.getEnunciado()+"%' ");
			}
		}
		
		//Dificuldade
		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
			if(!temParteWhere){
				select.append(" where questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.dificuldade ='"+dtoTemp.getDificuldade()+"' ");
			}
		}
		
//		Categoria
		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
			if(!temParteWhere){
				select.append(" where questao.categoria ='"+dtoTemp.getCategoria()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria ='"+dtoTemp.getCategoria()+"' ");
			}
		}else{
			if(!temParteWhere){
				select.append(" where questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
				temParteWhere=true;
			}else{
				select.append(" and questao.categoria <>'"+DominioCategoriaQuestao.getValorAvaliativa()+"' ");
			}
			
		}
		
		//Disciplina
		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
			if(!temParteWhere){
				select.append(" where questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.iddisciplina ="+dtoTemp.getIdDisciplina()+" ");
			}
		}
		
		//Conteudo
		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
			if(!temParteWhere){
				select.append(" where questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
				temParteWhere=true;
			}else{
				select.append(" and questao.idconteudo ="+dtoTemp.getIdConteudo()+" ");
			}
		}
		select.append(" order by disciplina.nomeDisciplina,questao.enunciado ");
		return select.toString();
	}

	public void putDto(ResultSet rs, QuestaoDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("idQuestao")));
		dto.setIdDisciplina(new Integer(rs.getString("idDisciplina")));
		dto.setIdConteudo(new Integer(rs.getString("idConteudo")));
		dto.setChavePessoa(new Integer(rs.getString("chavePessoa")));
		dto.setEnunciado(rs.getString("enunciado"));
		dto.setTipoQuestao(rs.getString("tipoQuestao"));
		dto.setDificuldade(rs.getString("dificuldade"));
		dto.setCategoria(rs.getString("categoria"));
		dto.setTempo(new Integer(rs.getString("tempo")));
		dto.setDtcriacao(UtilDate.getSqlDateComoDate(rs.getDate("dtcriacao")));
	}
	
	public void putDtoResponder(ResultSet rs, QuestaoDTO dto) throws SQLException{
		dto.setIdQuestao(new Integer(rs.getString("questao.idQuestao")));
		dto.setIdDisciplina(new Integer(rs.getString("questao.idDisciplina")));
		dto.setIdConteudo(new Integer(rs.getString("questao.idConteudo")));
		dto.setChavePessoa(new Integer(rs.getString("questao.chavePessoa")));
		dto.setEnunciado(rs.getString("questao.enunciado"));
		dto.setTipoQuestao(rs.getString("questao.tipoQuestao"));
		dto.setDificuldade(rs.getString("questao.dificuldade"));
		dto.setCategoria(rs.getString("questao.categoria"));
		dto.setTempo(new Integer(rs.getString("questao.tempo")));
		dto.setDtcriacao(UtilDate.getSqlDateComoDate(rs.getDate("questao.dtcriacao")));
		dto.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		dto.setNomeConteudo(rs.getString("conteudo.descricao"));
	}
	
	public void putDtoApoio(ResultSet rs, ApoioQuestao apoio) throws SQLException{
		apoio.setIdQuestao(rs.getString("idQuestao"));
		apoio.setIdDisciplina(rs.getString("idDisciplina"));
		apoio.setIdConteudo(rs.getString("idConteudo"));
		apoio.setChavePessoa(rs.getString("chavePessoa"));
		apoio.setEnunciado(rs.getString("enunciado"));
		apoio.setTipoQuestao(rs.getString("tipoQuestao"));
		apoio.setDificuldade(rs.getString("dificuldade"));
		apoio.setCategoria(rs.getString("categoria"));
		apoio.setTempo(rs.getString("tempo"));
		apoio.setDtcriacao(UtilDate.getDataComoString(UtilDate.getSqlDateComoDate(rs.getDate("dtcriacao"))));
		apoio.setNomeProfessor(rs.getString("nomePessoa"));
		apoio.setNomeDisciplina(rs.getString("nomeDisciplina"));
		apoio.setNomeConteudo(rs.getString("descricao"));
	}

}
