package questao.dao;

import java.sql.*;
import java.text.ParseException;
import java.util.Date;

import questao.dto.RelatorioAlunoDTO;
import questao.dto.RelatorioAluno_ComplementoDTO;
import questao.slave.*;
import questao.visao.VisaoQuestao;
import DominioDiaDaSemana.Dominio;
import dao.DAOBase;

public class RelatorioAlunoDAO extends DAOBase{
	
	public RelatorioAlunoDTO buscarTodoHistoricoDoAluno(Integer chaveAluno,String idLista, String idDisciplina, String idConteudo, String semestre, String ano, String listaOuQuestao, Integer perfil, String busca, Date dataInicial, Date dataFinal) throws SQLException, ParseException {
		String select = null;
		if(listaOuQuestao!=null && listaOuQuestao.equals(DominioListaOuQuestao.LISTA)){
			System.out.println("monta1");
			select = montaSelectLista(chaveAluno,idLista ,idDisciplina,idConteudo, semestre, ano, perfil, busca,dataInicial,dataFinal);
		} 
		else {
			System.out.println("monta2");
			select = montaSelectQuestaoAvulsa(chaveAluno,idDisciplina,idConteudo, semestre, ano, perfil, busca,dataInicial,dataFinal);
		}
		System.out.println(select);
		PreparedStatement ps = this.getConnection().prepareStatement(select);
		ResultSet rs = ps.executeQuery();
		RelatorioAlunoDTO dtoRelatorio = new RelatorioAlunoDTO();
		RelatorioAluno_ComplementoDTO dtoRel = new RelatorioAluno_ComplementoDTO();
		String idConteudoTemp = null;
		String idConteudoControlador = null;
		
		while(rs.next()){
			//Testa string vazia para carregar dados gerais
			if(dtoRelatorio.getNomeCurso()==null || dtoRelatorio.getNomeCurso().equals("")){
				carregaDadosGerais(rs, dtoRelatorio,idDisciplina, idLista, idConteudo, semestre, ano, listaOuQuestao,perfil, busca);
			}
			
			//Carregando disciplina pela 1 vez
			idConteudoTemp = rs.getString("conteudo.idConteudo");
			if(idConteudoControlador==null || idConteudoControlador.equals("")){
				idConteudoControlador = carregaDadosDoConteudo(rs, dtoRel, idConteudoTemp);
			}
			
			//Testando se mudou de disciplina
			if(!idConteudoControlador.equals(idConteudoTemp)){ 
				testaAdicionaConteudoNaLista(dtoRelatorio, dtoRel);
				dtoRel = new RelatorioAluno_ComplementoDTO();  //Reiniciando
				idConteudoControlador = carregaDadosDoConteudo(rs, dtoRel, idConteudoTemp);
			}
			
			//Testes para adicionar valores ao historio da mesma disciplina
			if(idConteudoControlador.equals(idConteudoTemp)){
				//Inicia teste do tipo de questao para adicionar na lista de historico
				ObjetoStrategy strategy = new ObjetoStrategy(this);
				strategy.addElemento(new ElementoQuestaoVouF(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoMultipla(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoEscolha(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoLacuna(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoAberta(rs,dtoRel));
				strategy.executaVerificacaoAninhada();
			}
		}
		//A ultima disciplina restante deve ser adicionada na lista
		testaAdicionaConteudoNaLista(dtoRelatorio, dtoRel);
		rs.close();
		return dtoRelatorio;
	}
	
	public RelatorioAlunoDTO buscarTodoHistoricoDoAlunoPerfilMonitor(Integer chaveAluno,String idLista, String idDisciplina, String idConteudo, String semestre, String ano, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws SQLException, ParseException {
		String select = null;
		if(listaOuQuestao!=null && listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
			select = montaSelectListaPerfilMonitor(chaveAluno,idLista ,idDisciplina,idConteudo, semestre, ano, chaveMonitor,dataInicial,dataFinal);
		else
			select = montaSelectQuestaoAvulsaPerfilMonitor(chaveAluno,idDisciplina,idConteudo, semestre, ano, chaveMonitor,dataInicial,dataFinal);
		PreparedStatement ps = this.getConnection().prepareStatement(select);
		ResultSet rs = ps.executeQuery();
		RelatorioAlunoDTO dtoRelatorio = new RelatorioAlunoDTO();
		RelatorioAluno_ComplementoDTO dtoRel = new RelatorioAluno_ComplementoDTO();
		String idConteudoTemp = null;
		String idConteudoControlador = null;
		
		while(rs.next()){
			//Testa string vazia para carregar dados gerais
			if(dtoRelatorio.getNomeCurso()==null || dtoRelatorio.getNomeCurso().equals("")){
				carregaDadosGeraisMonitor(rs, dtoRelatorio,idDisciplina, idLista, idConteudo, semestre, ano, listaOuQuestao);
			}
			
			//Carregando disciplina pela 1 vez
			idConteudoTemp = rs.getString("conteudo.idConteudo");
			if(idConteudoControlador==null || idConteudoControlador.equals("")){
				idConteudoControlador = carregaDadosDoConteudo(rs, dtoRel, idConteudoTemp);
			}
			
			//Testando se mudou de disciplina
			if(!idConteudoControlador.equals(idConteudoTemp)){ 
				testaAdicionaConteudoNaLista(dtoRelatorio, dtoRel);
				dtoRel = new RelatorioAluno_ComplementoDTO();  //Reiniciando
				idConteudoControlador = carregaDadosDoConteudo(rs, dtoRel, idConteudoTemp);
			}
			
			//Testes para adicionar valores ao historio da mesma disciplina
			if(idConteudoControlador.equals(idConteudoTemp)){
				//Inicia teste do tipo de questao para adicionar na lista de historico
				ObjetoStrategy strategy = new ObjetoStrategy(this);
				strategy.addElemento(new ElementoQuestaoVouF(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoMultipla(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoEscolha(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoLacuna(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoAberta(rs,dtoRel));
				strategy.executaVerificacaoAninhada();
			}
		}
		//A ultima disciplina restante deve ser adicionada na lista
		testaAdicionaConteudoNaLista(dtoRelatorio, dtoRel);
		rs.close();
		return dtoRelatorio;
	}

	
	private void carregaDadosGerais(ResultSet rs, RelatorioAlunoDTO dtoRelatorio, String idDisciplina, String idLista, String idConteudo, String semestre, String ano, String listaOuQuestao, Integer perfil, String busca) throws SQLException {
		dtoRelatorio.setNomeCurso(rs.getString("curso.nomeCurso"));
		dtoRelatorio.setNomeAluno(rs.getString("pessoa.nomePessoa"));
		dtoRelatorio.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		dtoRelatorio.setNomeProfessor(rs.getString("pessoaProfessor.nomePessoa"));
		if(busca!=null && busca.equalsIgnoreCase("professor"))
			dtoRelatorio.setMatriculaAluno(rs.getString("professor.matriculaFuncional"));
		else
			dtoRelatorio.setMatriculaAluno(rs.getString("aluno.matricula"));
		if(!VisaoQuestao.isStringVazia(idConteudo))
			dtoRelatorio.setDescricaoConteudo(rs.getString("conteudo.descricao"));
		if(!VisaoQuestao.isStringVazia(idLista))
			dtoRelatorio.setNomeLista(rs.getString("lista.tituloLista"));
		if(!VisaoQuestao.isStringVazia(semestre))
			dtoRelatorio.setSemestre(semestre);
		if(!VisaoQuestao.isStringVazia(ano))
			dtoRelatorio.setAno(ano);
		if(!VisaoQuestao.isStringVazia(listaOuQuestao)){
			if(listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
				dtoRelatorio.setListaOuQuestao("Questes em lista.");
			else
				dtoRelatorio.setListaOuQuestao("Questes fora da lista.");
		}
		dtoRelatorio.setDataDoRelatorio(UtilDate.getDataComoString(new Date()));
	}
	
	private void carregaDadosGeraisMonitor(ResultSet rs, RelatorioAlunoDTO dtoRelatorio, String idDisciplina, String idLista, String idConteudo, String semestre, String ano, String listaOuQuestao) throws SQLException {
		dtoRelatorio.setNomeCurso(rs.getString("curso.nomeCurso"));
		dtoRelatorio.setNomeAluno(rs.getString("pessoa.nomePessoa"));
		dtoRelatorio.setMatriculaAluno(rs.getString("aluno.matricula"));
		if(!VisaoQuestao.isStringVazia(idDisciplina))
			dtoRelatorio.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		if(!VisaoQuestao.isStringVazia(idConteudo))
			dtoRelatorio.setDescricaoConteudo(rs.getString("conteudo.descricao"));
		if(!VisaoQuestao.isStringVazia(idLista))
			dtoRelatorio.setNomeLista(rs.getString("lista.tituloLista"));
		if(!VisaoQuestao.isStringVazia(semestre))
			dtoRelatorio.setSemestre(semestre);
		if(!VisaoQuestao.isStringVazia(ano))
			dtoRelatorio.setAno(ano);
		if(!VisaoQuestao.isStringVazia(listaOuQuestao)){
			if(listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
				dtoRelatorio.setListaOuQuestao("Questes em lista.");
			else
				dtoRelatorio.setListaOuQuestao("Questes fora da lista.");
		}
		dtoRelatorio.setDataDoRelatorio(UtilDate.getDataComoString(new Date()));
	}

	private void testaAdicionaConteudoNaLista(RelatorioAlunoDTO dtoRelatorio, RelatorioAluno_ComplementoDTO dtoRel) {
		if(dtoRel!=null){
			//Niveis Facil, Mdio e Dificil
			dtoRel.setFacilAproveitamento(carregaValoresAproveitamento(dtoRel.getFacilRespondidas(),dtoRel.getFacilCertas()));
			dtoRel.setMediaAproveitamento(carregaValoresAproveitamento(dtoRel.getMediaRespondidas(),dtoRel.getMediaCertas()));
			dtoRel.setDificilAproveitamento(carregaValoresAproveitamento(dtoRel.getDificilRespondidas(),dtoRel.getDificilCertas()));
			
			//Dados Gerais
			dtoRel.setGeralRespondidas(dtoRel.getFacilRespondidas()+dtoRel.getMediaRespondidas()+dtoRel.getDificilRespondidas());
			dtoRel.setGeralCertas(dtoRel.getFacilCertas()+dtoRel.getMediaCertas()+dtoRel.getDificilCertas());
			dtoRel.setGeralErradas(dtoRel.getFacilErradas()+dtoRel.getMediaErradas()+dtoRel.getDificilErradas());
			dtoRel.setGeralAproveitamento(carregaValoresAproveitamento(dtoRel.getGeralRespondidas(),dtoRel.getGeralCertas()));
			
			dtoRelatorio.getListaDisciplina_Relatorio().add(dtoRel);
		}
	}
	
	private double carregaValoresAproveitamento(double respondidas, double certas) {
		if(respondidas<1)
			return 0;
		return	100*certas/respondidas;
	}

	private String carregaDadosDoConteudo(ResultSet rs, RelatorioAluno_ComplementoDTO dtoRel, String idConteudoTemp) throws SQLException {
		String idConteudoControlador;
		idConteudoControlador = idConteudoTemp;
		dtoRel.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		dtoRel.setCodigoTurma(rs.getString("turma.codigoTurma"));
		dtoRel.setSemestre(rs.getString("turma.semestre"));
		dtoRel.setNomeConteudo(rs.getString("conteudo.descricao"));
		return idConteudoControlador;
	}

	private String montaSelectQuestaoAvulsa(Integer chaveAluno, String idDisciplina, String idConteudo, String semestre, String ano, Integer perfil, String busca, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaAvulsa resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaAvulsa_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.chavePessoa=respostaAberta.chavePessoa and resposta.dtSolucao=respostaAberta.dtSolucao and resposta.horarioSolucao=respostaAberta.horarioSolucao ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		
		if(busca!=null && busca.equalsIgnoreCase("professor")){
			select.append("inner join maiorProfessor professor on professor.chavePessoa=pessoa.chavePessoa ");
			select.append("inner join maiorCurso curso on curso.codigoCurso = professor.codigoCursoVinculo ");
			select.append("inner join maiorTurma turma on turma.chavePessoaProfessor = professor.chavePessoa and turma.idDisciplina=questao.idDisciplina ");
			select.append("inner join maiorPessoa pessoaProfessor on turma.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
			select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
			select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
			select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
			select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
			montaParteWhereQuestaoAvulsa(select, chaveAluno, idDisciplina, idConteudo, semestre, ano, perfil, busca,dataInicial,dataFinal);
//			select.append("group by questao.idQuestao order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, questao.dificuldade");
			select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
			select.append("order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, conteudo.descricao, questao.dificuldade");
		}else{
			select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
			select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
			select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa and turma.idDisciplina=questao.idDisciplina and turma.ano = "+ano+" and turma.semestre = "+semestre + " ");
			select.append("inner join maiorTurma turmaGenerico on turmaGenerico.codigoTurma = turma.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
			select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
			select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
			select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
			select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
			select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
			montaParteWhereQuestaoAvulsa(select, chaveAluno, idDisciplina, idConteudo, semestre, ano, perfil, busca,dataInicial,dataFinal);
//			select.append("group by questao.idQuestao order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, questao.dificuldade");
			select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
			select.append("order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, conteudo.descricao, questao.dificuldade");
		}
		
		return select.toString();
	}

	private void montaParteWhereQuestaoAvulsa(StringBuffer select, Integer chaveAluno, String idDisciplina, String idConteudo, String semestre, String ano, Integer perfil, String busca, Date dataInicial, Date dataFinal) throws ParseException {
		if(busca!=null && busca.equalsIgnoreCase("professor")){
			select.append("where professor.chavePessoa="+chaveAluno.intValue()+" ");
		}else{
			select.append("where aluno.chavePessoa="+chaveAluno.intValue()+" ");
		}
		if(!VisaoQuestao.isStringVazia(idDisciplina))
			select.append("and disciplina.idDisciplina="+idDisciplina+" ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano)){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
	}
	
	private String montaSelectLista(Integer chaveAluno, String idLista, String idDisciplina, String idConteudo, String semestre, String ano, Integer perfil, String busca, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaLista resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaLista_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.idLista=respostaAberta.idLista and resposta.chavePessoa=respostaAberta.chavePessoa ");
		select.append("inner join bdqLista lista on lista.idLista=resposta.idLista ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		
		
		if(busca!=null && busca.equalsIgnoreCase("professor")){
			select.append("inner join maiorProfessor professor on professor.chavePessoa=pessoa.chavePessoa ");
			select.append("inner join maiorCurso curso on curso.codigoCurso = professor.codigoCursoVinculo ");
			select.append("inner join maiorTurma turma on turma.chavePessoaProfessor = professor.chavePessoa and turma.idDisciplina=questao.idDisciplina ");
			select.append("inner join maiorPessoa pessoaProfessor on turma.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
			select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
			select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
			select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
			select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
			montaParteWhereLista(select, chaveAluno,idLista, idDisciplina, idConteudo, semestre, ano, perfil,dataInicial,dataFinal);
			select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
			select.append("group by questao.idQuestao order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, conteudo.descricao, questao.dificuldade");
		}else{
			System.out.println("entrou no ponto 2");
			select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
			select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
			select.append("inner join maiorProfessor professor on professor.codigoCursoVinculo=curso.codigoCurso ");
			select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa and turma.idDisciplina=questao.idDisciplina and turma.ano = "+ano+" and turma.semestre = "+semestre );
			select.append("inner join maiorTurma turmaGenerico on turma.codigoTurma = turmaGenerico.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
			select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
			select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
			select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
			select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
			select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
			montaParteWhereLista(select, chaveAluno,idLista, idDisciplina, idConteudo, semestre, ano, perfil,dataInicial,dataFinal);
			select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
			select.append("group by questao.idQuestao order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, conteudo.descricao, questao.dificuldade");
		}
		return select.toString();
	}
	
	private void montaParteWhereLista(StringBuffer select, Integer chaveAluno, String idLista, String idDisciplina, String idConteudo, String semestre, String ano, Integer perfil, Date dataInicial, Date dataFinal) throws ParseException {
		if(perfil.intValue()==Dominio.getProfessor().intValue()){
			select.append("where professor.chavePessoa="+chaveAluno.intValue()+" ");
		}else{
			select.append("where aluno.chavePessoa="+chaveAluno.intValue()+" ");
		}
		if(!VisaoQuestao.isStringVazia(idLista))
			select.append("and resposta.idLista="+idLista+" ");
		
		if(!VisaoQuestao.isStringVazia(idDisciplina))
			select.append("and disciplina.idDisciplina="+idDisciplina+" ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano)){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano))+"' ");
		}
		
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
	}
	
	private String montaSelectQuestaoAvulsaPerfilMonitor(Integer chaveAluno, String idDisciplina, String idConteudo, String semestre, String ano, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaAvulsa resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaAvulsa_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao  and resposta.chavePessoa=respostaAberta.chavePessoa and resposta.dtSolucao=respostaAberta.dtSolucao and resposta.horarioSolucao=respostaAberta.horarioSolucao ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
		select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina = questao.idDisciplina ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa and turma.idDisciplina=questao.idDisciplina and turma.ano = "+ano+" and turma.semestre = "+semestre + " ");
		select.append("inner join maiorTurma turmaGenerico on turma.codigoTurma = turmaGenerico.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
		select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
		montaParteWhereQuestaoAvulsaPerfilMonitor(select, chaveAluno, idDisciplina, idConteudo, semestre, ano, chaveMonitor,dataInicial,dataFinal);
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		select.append("order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, conteudo.descricao, questao.dificuldade");
		return select.toString();
	}

	private void montaParteWhereQuestaoAvulsaPerfilMonitor(StringBuffer select, Integer chaveAluno, String idDisciplina, String idConteudo, String semestre, String ano, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		select.append("where aluno.chavePessoa="+chaveAluno.intValue()+" and monitoria.chavePessoa="+chaveMonitor.intValue()+" ");
		if(!VisaoQuestao.isStringVazia(idDisciplina))
			select.append("and disciplina.idDisciplina="+idDisciplina+" ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano)){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano))+"' ");
		}
		
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
	}
	
	private String montaSelectListaPerfilMonitor(Integer chaveAluno, String idLista, String idDisciplina, String idConteudo, String semestre, String ano, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaLista resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaLista_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.idLista=respostaAberta.idLista and resposta.chavePessoa=respostaAberta.chavePessoa ");
		select.append("inner join bdqLista lista on lista.idLista=resposta.idLista ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
		select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina = questao.idDisciplina ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa and turma.idDisciplina=questao.idDisciplina  and turma.ano = "+ano+" and turma.semestre = "+semestre + " ");
		select.append("inner join maiorTurma turmaGenerico on turmaGenerico.codigoTurma = turmaGenerico.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
		select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		montaParteWhereListaPerfilMonitor(select, chaveAluno,idLista, idDisciplina, idConteudo, semestre, ano, chaveMonitor,dataInicial,dataFinal);
		select.append("order by turma.semestre, disciplina.nomeDisciplina, disciplina.idDisciplina, conteudo.descricao, questao.dificuldade");
		return select.toString();
	}
	
	private void montaParteWhereListaPerfilMonitor(StringBuffer select, Integer chaveAluno, String idLista, String idDisciplina, String idConteudo, String semestre, String ano, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		select.append("where aluno.chavePessoa="+chaveAluno.intValue()+" and monitoria.chavePessoa="+chaveMonitor.intValue()+" ");
		if(!VisaoQuestao.isStringVazia(idLista))
			select.append("and resposta.idLista="+idLista+" ");
		
		if(!VisaoQuestao.isStringVazia(idDisciplina))
			select.append("and disciplina.idDisciplina="+idDisciplina+" ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano)){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano))+"' ");
		}
		
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
	}
	
}
