package questao.dao;

import java.sql.*;
import java.text.ParseException;
import java.util.Date;

import questao.dto.RelatorioDisciplinaDTO;
import questao.dto.RelatorioDisciplina_ComplementoDTO;
import questao.slave.*;
import questao.visao.VisaoQuestao;
import dao.DAOBase;

public class RelatorioDisciplinaDAO extends DAOBase{
		
	public RelatorioDisciplinaDTO buscarRelatorioDisciplinaPorIdDisciplina(Integer idDisciplina,String idConteudo, Integer ano, String semestre, String idLista, String listaOuQuestao, Date dataInicial, Date dataFinal ) throws SQLException, ParseException {
		String select = null;
		if(listaOuQuestao!=null && listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
			select = montaSelectLista(idDisciplina, idConteudo, ano, semestre, idLista, listaOuQuestao,dataInicial,dataFinal);
		else
			select = montaSelect(idDisciplina, idConteudo, ano, semestre, listaOuQuestao,dataInicial,dataFinal);
		
		System.out.println(select);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setInt(1,idDisciplina.intValue());
//		ps.setInt(2,ano.intValue());
//		ps.setString(3,semestre);
//		if(!VisaoQuestao.isStringVazia(idLista))
//			ps.setInt(4,Integer.parseInt(idLista));
		ResultSet rs = ps.executeQuery();
		RelatorioDisciplinaDTO dtoRelatorio = new RelatorioDisciplinaDTO();
		RelatorioDisciplina_ComplementoDTO dtoRel = new RelatorioDisciplina_ComplementoDTO();
		String codigoTurmaTemp = null;
		String codigoTurmaControlador = null;
		
		while(rs.next()){
			
//			Testa string vazia para carregar dados gerais
			if(dtoRelatorio.getNomeCurso()==null || dtoRelatorio.getNomeCurso().equals("")){
				carregaDadosGerais(rs, dtoRelatorio);
			}
			
			//Carregando aluno pela 1 vez
			codigoTurmaTemp = rs.getString("turma.codigoTurma");
			if(codigoTurmaControlador==null || codigoTurmaControlador.equals("")){
				codigoTurmaControlador = carregaDadosDoAluno(rs, dtoRel, codigoTurmaTemp);
			}
						
			//Testando se mudou de aluno
			if(!codigoTurmaControlador.equals(codigoTurmaTemp)){ //Mudou de disciplina
				testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
				dtoRel = new RelatorioDisciplina_ComplementoDTO();  //Reiniciando
				codigoTurmaControlador = carregaDadosDoAluno(rs, dtoRel, codigoTurmaTemp);
			}
			
			//Testes para adicionar valores ao historio do mesmo aluno
			if(codigoTurmaControlador.equals(codigoTurmaTemp)){ 
				//Inicia teste do tipo de questao para adicionar na lista de historico
				ObjetoStrategy strategy = new ObjetoStrategy(this);
				strategy.addElemento(new ElementoQuestaoVouF(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoMultipla(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoEscolha(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoLacuna(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoAberta(rs,dtoRel));
				strategy.executaVerificacaoAninhada(); 
			}
		}
		//O ultimo aluno restante deve ser adicionada na lista
		testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
		rs.close();
		return dtoRelatorio;
	}
	
	public RelatorioDisciplinaDTO buscarRelatorioDisciplinaPorIdDisciplinaPerfilMonitor(Integer idDisciplina,String idConteudo, Integer ano, String semestre, String idLista, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal ) throws SQLException, ParseException {
		String select = null;
		if(listaOuQuestao!=null && listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
			select = montaSelectListaPerfilMonitor(idDisciplina,idConteudo, ano, semestre, idLista, listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		else
			select = montaSelectPerfilMonitor(idDisciplina,idConteudo, ano, semestre, listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setInt(1,idDisciplina.intValue());
//		ps.setInt(2,ano.intValue());
//		ps.setString(3,semestre);
//		ps.setInt(4,chaveMonitor.intValue());
//		if(!VisaoQuestao.isStringVazia(idLista))
//			ps.setInt(5,Integer.parseInt(idLista));
		ResultSet rs = ps.executeQuery();
		RelatorioDisciplinaDTO dtoRelatorio = new RelatorioDisciplinaDTO();
		RelatorioDisciplina_ComplementoDTO dtoRel = new RelatorioDisciplina_ComplementoDTO();
		String codigoTurmaTemp = null;
		String codigoTurmaControlador = null;
		
		while(rs.next()){
			
			//Testa string vazia para carregar dados gerais
			if(dtoRelatorio.getNomeCurso()==null || dtoRelatorio.getNomeCurso().equals("")){
				carregaDadosGerais(rs, dtoRelatorio);
			}
			
			//Carregando aluno pela 1 vez
			codigoTurmaTemp = rs.getString("turma.codigoTurma");
			if(codigoTurmaControlador==null || codigoTurmaControlador.equals("")){
				codigoTurmaControlador = carregaDadosDoAluno(rs, dtoRel, codigoTurmaTemp);
			}
						
			//Testando se mudou de aluno
			if(!codigoTurmaControlador.equals(codigoTurmaTemp)){ //Mudou de disciplina
				testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
				dtoRel = new RelatorioDisciplina_ComplementoDTO();  //Reiniciando
				codigoTurmaControlador = carregaDadosDoAluno(rs, dtoRel, codigoTurmaTemp);
			}
			
			//Testes para adicionar valores ao historio do mesmo aluno
			if(codigoTurmaControlador.equals(codigoTurmaTemp)){ 
				//Inicia teste do tipo de questao para adicionar na lista de historico
				ObjetoStrategy strategy = new ObjetoStrategy(this);
				strategy.addElemento(new ElementoQuestaoVouF(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoMultipla(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoEscolha(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoLacuna(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoAberta(rs,dtoRel));
				strategy.executaVerificacaoAninhada(); 
			}
		}
		//O ultimo aluno restante deve ser adicionada na lista
		testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
		rs.close();
		return dtoRelatorio;
	}
	
	private void carregaDadosGerais(ResultSet rs, RelatorioDisciplinaDTO dtoRelatorio) throws SQLException {
		dtoRelatorio.setNomeCurso(rs.getString("curso.nomeCurso"));
		dtoRelatorio.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		dtoRelatorio.setAno(rs.getString("turma.ano"));
		dtoRelatorio.setDataDoRelatorio(UtilDate.getDataComoString(new Date()));
	}

	private void testaAdicionaAlunoNaLista(RelatorioDisciplinaDTO dtoRelatorio, RelatorioDisciplina_ComplementoDTO dtoRel) {
		if(dtoRel!=null){
			//Niveis Facil, Mdio e Dificil
			dtoRel.setFacilAproveitamento(carregaValoresAproveitamento(dtoRel.getFacilRespondidas(),dtoRel.getFacilCertas()));
			dtoRel.setMediaAproveitamento(carregaValoresAproveitamento(dtoRel.getMediaRespondidas(),dtoRel.getMediaCertas()));
			dtoRel.setDificilAproveitamento(carregaValoresAproveitamento(dtoRel.getDificilRespondidas(),dtoRel.getDificilCertas()));
			
			//Dados Gerais
			dtoRel.setGeralRespondidas(dtoRel.getFacilRespondidas()+dtoRel.getMediaRespondidas()+dtoRel.getDificilRespondidas());
			dtoRel.setGeralCertas(dtoRel.getFacilCertas()+dtoRel.getMediaCertas()+dtoRel.getDificilCertas());
			dtoRel.setGeralErradas(dtoRel.getFacilErradas()+dtoRel.getMediaErradas()+dtoRel.getDificilErradas());
			dtoRel.setGeralAproveitamento(carregaValoresAproveitamento(dtoRel.getGeralRespondidas(),dtoRel.getGeralCertas()));
			
			dtoRelatorio.getListaDisciplina_Relatorio().add(dtoRel);
		}
	}
	
	private double carregaValoresAproveitamento(double respondidas, double certas) {
		if(respondidas<1)
			return 0;
		return	100*certas/respondidas;
	}
	
	private String carregaDadosDoAluno(ResultSet rs, RelatorioDisciplina_ComplementoDTO dtoRel, String chavePessoaTemp) throws SQLException {
		String chavePessoaControlador;
		chavePessoaControlador = chavePessoaTemp;
		dtoRel.setNomeAluno(rs.getString("pessoa.nomePessoa"));
//		dtoRel.setMatriculaAluno(rs.getString("aluno.matricula"));
		dtoRel.setTurmaAluno(rs.getString("turma.codigoTurma"));
		dtoRel.setSemestre(rs.getString("turma.semestre"));
		return chavePessoaControlador;
	}
	
	private String montaSelect(Integer idDisciplina, String idConteudo, Integer ano, String semestre, String listaOuQuestao, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaAvulsa resposta on resposta.idQuestao=questao.idQuestao "); 
		select.append("left join bdqRespostaAvulsa_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.chavePessoa=respostaAberta.chavePessoa and resposta.dtSolucao=respostaAberta.dtSolucao and resposta.horarioSolucao=respostaAberta.horarioSolucao "); 
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorCurso_Disciplina cursoDisciplina on cursoDisciplina.idDisciplina = disciplina.idDisciplina "); 
		select.append("inner join maiorCurso curso on curso.codigoCurso = cursoDisciplina.codigoCurso ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao "); 
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("left join bdqAberta aberta on questao.idQuestao = aberta.idQuestao ");
		select.append("inner join maiorTurma_Aluno turmaRel on turmaRel.chavePessoaAluno = resposta.chavePessoa and turmaRel.idDisciplina=questao.idDisciplina ");
		select.append("inner join maiorTurma turma on  turma.codigoTurma = turmaRel.codigoTurma and turma.codigoCurso = turmaRel.codigoCurso and  turma.idDisciplina = turmaRel.idDisciplina and  turma.ano = turmaRel.ano and  turma.semestre = turmaRel.semestre "); 
		select.append("where turma.idDisciplina="+idDisciplina.toString()+" ");
		select.append("and turma.ano="+ano.toString()+" ");
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		
		if(!VisaoQuestao.isStringVazia(semestre))
			select.append("and turma.semestre="+semestre+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		
		//select.append("group by resposta.dtSolucao,resposta.horarioSolucao ");
		select.append("order by turma.codigoTurma,turma.codigoCurso, turma.idDisciplina, turma.semestre, turma.ano, pessoa.nomePessoa, pessoa.chavePessoa");
		return select.toString();
	}

	private String montaSelectLista(Integer idDisciplina, String idConteudo, Integer ano, String semestre, String idLista, String listaOuQuestao, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaLista resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaLista_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.idLista=respostaAberta.idLista and resposta.chavePessoa=respostaAberta.chavePessoa ");
		select.append("inner join bdqLista lista on lista.idLista=resposta.idLista ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorCurso_Disciplina cursoDisciplina on cursoDisciplina.idDisciplina = disciplina.idDisciplina "); 
		select.append("inner join maiorCurso curso on curso.codigoCurso = cursoDisciplina.codigoCurso ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao "); 
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("left join bdqAberta aberta on questao.idQuestao = aberta.idQuestao ");
		select.append("inner join maiorTurma_Aluno turmaRel on turmaRel.chavePessoaAluno = resposta.chavePessoa and turmaRel.idDisciplina=questao.idDisciplina ");
		select.append("inner join maiorTurma turma on  turma.codigoTurma = turmaRel.codigoTurma and turma.codigoCurso = turmaRel.codigoCurso and  turma.idDisciplina = turmaRel.idDisciplina and  turma.ano = turmaRel.ano and  turma.semestre = turmaRel.semestre ");
		select.append("where turma.idDisciplina="+idDisciplina.toString()+" ");
		select.append("and turma.ano="+ano.toString()+" ");
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre))
			select.append("and turma.semestre="+semestre+" ");
		
		if(!VisaoQuestao.isStringVazia(idLista))
			select.append("and lista.idLista="+idLista+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		select.append("order by turma.codigoTurma,turma.codigoCurso, turma.idDisciplina, turma.semestre, turma.ano, pessoa.nomePessoa, pessoa.chavePessoa");
		return select.toString();
	}
	
	private String montaSelectPerfilMonitor(Integer idDisciplina, String idConteudo, Integer ano, String semestre, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaAvulsa resposta on resposta.idQuestao=questao.idQuestao "); 
		select.append("left join bdqRespostaAvulsa_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.chavePessoa=respostaAberta.chavePessoa and resposta.dtSolucao=respostaAberta.dtSolucao and resposta.horarioSolucao=respostaAberta.horarioSolucao "); 
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorCurso_Disciplina cursoDisciplina on cursoDisciplina.idDisciplina = disciplina.idDisciplina "); 
		select.append("inner join maiorCurso curso on curso.codigoCurso = cursoDisciplina.codigoCurso ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina = questao.idDisciplina ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao "); 
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("left join bdqAberta aberta on questao.idQuestao = aberta.idQuestao ");
		select.append("inner join maiorTurma_Aluno turmaRel on turmaRel.chavePessoaAluno = resposta.chavePessoa and turmaRel.idDisciplina=questao.idDisciplina ");
		select.append("inner join maiorTurma turma on  turma.codigoTurma = turmaRel.codigoTurma and turma.codigoCurso = turmaRel.codigoCurso and  turma.idDisciplina = turmaRel.idDisciplina and  turma.ano = turmaRel.ano and  turma.semestre = turmaRel.semestre "); 
		select.append("where turma.idDisciplina="+idDisciplina.toString()+" ");
		select.append("and turma.ano="+ano.toString()+" ");
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		
		
		if(chaveMonitor!=null && chaveMonitor.intValue()>0)
			select.append("and monitoria.chavePessoa="+chaveMonitor.toString()+" ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre))
			select.append("and turma.semestre="+semestre+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		
		select.append("order by turma.codigoTurma,turma.codigoCurso, turma.idDisciplina, turma.semestre, turma.ano, pessoa.nomePessoa, pessoa.chavePessoa");
		
		return select.toString();
	}
	
	private String montaSelectListaPerfilMonitor(Integer idDisciplina, String idConteudo, Integer ano, String semestre, String idLista, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();

		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaLista resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaLista_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.idLista=respostaAberta.idLista and resposta.chavePessoa=respostaAberta.chavePessoa ");
		select.append("inner join bdqLista lista on lista.idLista=resposta.idLista ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorCurso_Disciplina cursoDisciplina on cursoDisciplina.idDisciplina = disciplina.idDisciplina "); 
		select.append("inner join maiorCurso curso on curso.codigoCurso = cursoDisciplina.codigoCurso ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina = questao.idDisciplina ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao "); 
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("left join bdqAberta aberta on questao.idQuestao = aberta.idQuestao ");
		select.append("inner join maiorTurma_Aluno turmaRel on turmaRel.chavePessoaAluno = resposta.chavePessoa and turmaRel.idDisciplina=questao.idDisciplina ");
		select.append("inner join maiorTurma turma on  turma.codigoTurma = turmaRel.codigoTurma and turma.codigoCurso = turmaRel.codigoCurso and  turma.idDisciplina = turmaRel.idDisciplina and  turma.ano = turmaRel.ano and  turma.semestre = turmaRel.semestre "); 
		select.append("where turma.idDisciplina="+idDisciplina.toString()+" ");
		select.append("and turma.ano="+ano.toString()+" ");
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		
		if(chaveMonitor!=null && chaveMonitor.intValue()>0)
			select.append("and monitoria.chavePessoa="+chaveMonitor.toString()+" ");
		
		if(!VisaoQuestao.isStringVazia(idConteudo))
			select.append("and conteudo.idConteudo="+idConteudo+" ");

		if(!VisaoQuestao.isStringVazia(idLista))
			select.append("and lista.idLista=? ");
		
		if(!VisaoQuestao.isStringVazia(semestre))
			select.append("and turma.semestre="+semestre+" ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		
		select.append("order by turma.codigoTurma,turma.codigoCurso, turma.idDisciplina, turma.semestre, turma.ano, pessoa.nomePessoa, pessoa.chavePessoa");
		return select.toString();
	}
	
}