package questao.dao;

import java.sql.*;
import java.text.ParseException;
import java.util.Date;

import questao.dto.RelatorioTurmaDTO;
import questao.dto.RelatorioTurma_ComplementoDTO;
import questao.slave.*;
import questao.visao.VisaoQuestao;
import dao.DAOBase;

public class RelatorioTurmaDAO extends DAOBase{
		
	public RelatorioTurmaDTO buscarDadosDaTurmaPorCodigoDaTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String idLista, String listaOuQuestao, Date dataInicial, Date dataFinal ) throws SQLException, ParseException {
		String select = null;
		if(listaOuQuestao!=null && listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
			select = montaSelectLista(idLista,codigoTurma,codigoCurso, idDisciplina, ano, semestre, listaOuQuestao,dataInicial,dataFinal);
		else
			select = montaSelect(codigoTurma,codigoCurso, idDisciplina, ano, semestre, listaOuQuestao,dataInicial,dataFinal);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setString(1,codigoTurma);
//		ps.setInt(2,codigoCurso.intValue());
//		ps.setInt(3,idDisciplina.intValue());
//		ps.setInt(4,ano.intValue());
//		ps.setString(5,semestre);
//		if(!VisaoQuestao.isStringVazia(idLista))
//			ps.setInt(6,Integer.parseInt(idLista));
		ResultSet rs = ps.executeQuery();
		RelatorioTurmaDTO dtoRelatorio = new RelatorioTurmaDTO();
		RelatorioTurma_ComplementoDTO dtoRel = new RelatorioTurma_ComplementoDTO();
		String chavePessoaTemp = null;
		String chavePessoaControlador = null;
		
		while(rs.next()){
			
			//Testa string vazia para carregar dados gerais
			if(dtoRelatorio.getNomeCurso()==null || dtoRelatorio.getNomeCurso().equals("")){
				carregaDadosGerais(rs, dtoRelatorio);
			}
			
			//Carregando aluno pela 1 vez
			chavePessoaTemp = rs.getString("pessoa.chavePessoa");
			if(chavePessoaControlador==null || chavePessoaControlador.equals("")){
				chavePessoaControlador = carregaDadosDoAluno(rs, dtoRel, chavePessoaTemp);
			}
						
			//Testando se mudou de aluno
			if(!chavePessoaControlador.equals(chavePessoaTemp)){ //Mudou de disciplina
				testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
				dtoRel = new RelatorioTurma_ComplementoDTO();  //Reiniciando
				chavePessoaControlador = carregaDadosDoAluno(rs, dtoRel, chavePessoaTemp);
			}
			
			//Testes para adicionar valores ao historio do mesmo aluno
			if(chavePessoaControlador.equals(chavePessoaTemp)){ 
				//Inicia teste do tipo de questao para adicionar na lista de historico
				ObjetoStrategy strategy = new ObjetoStrategy(this);
				strategy.addElemento(new ElementoQuestaoVouF(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoMultipla(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoEscolha(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoLacuna(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoAberta(rs,dtoRel));
				strategy.executaVerificacaoAninhada(); 
			}
		}
		//O ultimo aluno restante deve ser adicionada na lista
		testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
		rs.close();
		return dtoRelatorio;
	}
	
	public RelatorioTurmaDTO buscarDadosDaTurmaPorCodigoDaTurmaPerfilMonitor(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String idLista, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal ) throws SQLException, ParseException {
		String select = null;
		if(listaOuQuestao!=null && listaOuQuestao.equals(DominioListaOuQuestao.LISTA))
			select = montaSelectListaPerfilMonitor(idLista,codigoTurma,codigoCurso, idDisciplina, ano, semestre, listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		else
			select = montaSelectPerfilMonitor(codigoTurma,codigoCurso, idDisciplina, ano, semestre, listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setString(1,codigoTurma);
//		ps.setInt(2,codigoCurso.intValue());
//		ps.setInt(3,idDisciplina.intValue());
//		ps.setInt(4,ano.intValue());
//		ps.setString(5,semestre);
//		ps.setInt(6,chaveMonitor.intValue());
//		if(!VisaoQuestao.isStringVazia(idLista))
//			ps.setInt(7,Integer.parseInt(idLista));
		ResultSet rs = ps.executeQuery();
		RelatorioTurmaDTO dtoRelatorio = new RelatorioTurmaDTO();
		RelatorioTurma_ComplementoDTO dtoRel = new RelatorioTurma_ComplementoDTO();
		String chavePessoaTemp = null;
		String chavePessoaControlador = null;
		
		while(rs.next()){
			
			//Testa string vazia para carregar dados gerais
			if(dtoRelatorio.getNomeCurso()==null || dtoRelatorio.getNomeCurso().equals("")){
				carregaDadosGerais(rs, dtoRelatorio);
			}
			
			//Carregando aluno pela 1 vez
			chavePessoaTemp = rs.getString("pessoa.chavePessoa");
			if(chavePessoaControlador==null || chavePessoaControlador.equals("")){
				chavePessoaControlador = carregaDadosDoAluno(rs, dtoRel, chavePessoaTemp);
			}
						
			//Testando se mudou de aluno
			if(!chavePessoaControlador.equals(chavePessoaTemp)){ //Mudou de disciplina
				testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
				dtoRel = new RelatorioTurma_ComplementoDTO();  //Reiniciando
				chavePessoaControlador = carregaDadosDoAluno(rs, dtoRel, chavePessoaTemp);
			}
			
			//Testes para adicionar valores ao historio do mesmo aluno
			if(chavePessoaControlador.equals(chavePessoaTemp)){ 
				//Inicia teste do tipo de questao para adicionar na lista de historico
				ObjetoStrategy strategy = new ObjetoStrategy(this);
				strategy.addElemento(new ElementoQuestaoVouF(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoMultipla(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoEscolha(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoLacuna(rs,dtoRel));
				strategy.addElemento(new ElementoQuestaoAberta(rs,dtoRel));
				strategy.executaVerificacaoAninhada(); 
			}
		}
		//O ultimo aluno restante deve ser adicionada na lista
		testaAdicionaAlunoNaLista(dtoRelatorio, dtoRel);
		rs.close();
		return dtoRelatorio;
	}
	
	private void carregaDadosGerais(ResultSet rs, RelatorioTurmaDTO dtoRelatorio) throws SQLException {
		dtoRelatorio.setNomeCurso(rs.getString("curso.nomeCurso"));
		dtoRelatorio.setNomeDisciplina(rs.getString("disciplina.nomeDisciplina"));
		dtoRelatorio.setCodigoTurma(rs.getString("turma.codigoTurma"));
		dtoRelatorio.setSemestre(rs.getString("turma.semestre"));
		dtoRelatorio.setDataDoRelatorio(UtilDate.getDataComoString(new Date()));
		dtoRelatorio.setNomeProfessor(rs.getString("pessoaProfessor.nomePessoa"));
	}

	private void testaAdicionaAlunoNaLista(RelatorioTurmaDTO dtoRelatorio, RelatorioTurma_ComplementoDTO dtoRel) {
		if(dtoRel!=null){
			//Niveis Facil, Mdio e Dificil
			dtoRel.setFacilAproveitamento(carregaValoresAproveitamento(dtoRel.getFacilRespondidas(),dtoRel.getFacilCertas()));
			dtoRel.setMediaAproveitamento(carregaValoresAproveitamento(dtoRel.getMediaRespondidas(),dtoRel.getMediaCertas()));
			dtoRel.setDificilAproveitamento(carregaValoresAproveitamento(dtoRel.getDificilRespondidas(),dtoRel.getDificilCertas()));
			
			//Dados Gerais
			dtoRel.setGeralRespondidas(dtoRel.getFacilRespondidas()+dtoRel.getMediaRespondidas()+dtoRel.getDificilRespondidas());
			dtoRel.setGeralCertas(dtoRel.getFacilCertas()+dtoRel.getMediaCertas()+dtoRel.getDificilCertas());
			dtoRel.setGeralErradas(dtoRel.getFacilErradas()+dtoRel.getMediaErradas()+dtoRel.getDificilErradas());
			dtoRel.setGeralAproveitamento(carregaValoresAproveitamento(dtoRel.getGeralRespondidas(),dtoRel.getGeralCertas()));
			
			dtoRelatorio.getListaDisciplina_Relatorio().add(dtoRel);
		}
	}
	
	private double carregaValoresAproveitamento(double respondidas, double certas) {
		if(respondidas<1)
			return 0;
		return	100*certas/respondidas;
	}
	
	private String carregaDadosDoAluno(ResultSet rs, RelatorioTurma_ComplementoDTO dtoRel, String chavePessoaTemp) throws SQLException {
		String chavePessoaControlador;
		chavePessoaControlador = chavePessoaTemp;
		dtoRel.setNomeAluno(rs.getString("pessoa.nomePessoa"));
		dtoRel.setMatriculaAluno(rs.getString("aluno.matricula"));
		return chavePessoaControlador;
	}
	
	private String montaSelect(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String listaOuQuestao, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaAvulsa resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaAvulsa_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.chavePessoa=respostaAberta.chavePessoa and resposta.dtSolucao=respostaAberta.dtSolucao and resposta.horarioSolucao=respostaAberta.horarioSolucao ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
		select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa ");
		select.append("inner join maiorTurma turmaGenerico on turmaGenerico.codigoTurma = turma.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
		select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
		select.append("where turma.codigoTurma='"+codigoTurma+"' and turma.codigoCurso="+codigoCurso.toString()+" ");
		select.append("and turma.idDisciplina="+idDisciplina.toString()+" and turma.ano="+ano.toString()+" and turma.semestre="+semestre+" ");
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		select.append("order by pessoa.nomePessoa, pessoa.chavePessoa");
		return select.toString();
	}
	
	private String montaSelectLista(String idLista, String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String listaOuQuestao, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaLista resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaLista_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.idLista=respostaAberta.idLista and resposta.chavePessoa=respostaAberta.chavePessoa ");
		select.append("inner join bdqLista lista on lista.idLista=resposta.idLista ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
		select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa ");
		select.append("inner join maiorTurma turmaGenerico on turmaGenerico.codigoTurma = turma.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
		select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
		select.append("where turma.codigoTurma='"+codigoTurma.toString()+"' and turma.codigoCurso="+codigoCurso.toString()+" ");
		select.append("and turma.idDisciplina="+idDisciplina.toString()+" and turma.ano="+ano.toString()+" and turma.semestre="+semestre+" ");
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		if(!VisaoQuestao.isStringVazia(idLista))
			select.append("and lista.idLista=? ");
		select.append(" and (respostaAberta.correcao <> 'A' ) ");
		select.append("order by pessoa.nomePessoa, pessoa.chavePessoa");
		return select.toString();
	}
	
	private String montaSelectPerfilMonitor(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaAvulsa resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaAvulsa_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.chavePessoa=respostaAberta.chavePessoa and resposta.dtSolucao=respostaAberta.dtSolucao and resposta.horarioSolucao=respostaAberta.horarioSolucao ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
		select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina = questao.idDisciplina ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa ");
		select.append("inner join maiorTurma turmaGenerico on turmaGenerico.codigoTurma = turma.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
		select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
		select.append("where turma.codigoTurma='"+codigoTurma.toString()+"' and turma.codigoCurso="+codigoCurso.toString()+" ");
		select.append("and turma.idDisciplina="+idDisciplina.toString()+" and turma.ano="+ano.toString()+" and turma.semestre='"+semestre+"' ");
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) and monitoria.chavePessoa="+chaveMonitor+" ");
		select.append("order by pessoa.nomePessoa, pessoa.chavePessoa");
		
		return select.toString();
	}
	
	private String montaSelectListaPerfilMonitor(String idLista, String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal) throws ParseException {
		StringBuffer select = new StringBuffer();
		select.append("select * from bdqQuestao questao ");
		select.append("inner join bdqAluno_RespostaLista resposta on resposta.idQuestao=questao.idQuestao ");
		select.append("left join bdqRespostaLista_Aberta respostaAberta on resposta.idQuestao=respostaAberta.idQuestao and resposta.idLista=respostaAberta.idLista and resposta.chavePessoa=respostaAberta.chavePessoa ");
		select.append("inner join bdqLista lista on lista.idLista=resposta.idLista ");
		select.append("inner join maiorDisciplina disciplina on disciplina.idDisciplina = questao.idDisciplina ");
		select.append("inner join maiorConteudo conteudo on conteudo.idConteudo = questao.idConteudo ");
		select.append("inner join maiorPessoa pessoa on resposta.chavePessoa = pessoa.chavePessoa ");
		select.append("inner join maiorAluno aluno on aluno.chavePessoa=pessoa.chavePessoa ");
		select.append("inner join maiorCurso curso on curso.codigoCurso = aluno.codigoCurso ");
		select.append("left join bdqVouF vouf on questao.idQuestao = vouf.idQuestao ");
		select.append("inner join maiorMonitor monitoria on monitoria.idDisciplina = questao.idDisciplina ");
		select.append("left join bdqMultipla multipla on questao.idQuestao = multipla.idQuestao ");
		select.append("left join bdqEscolhas escolha on questao.idQuestao = escolha.idQuestao ");
		select.append("left join bdqLacuna lacuna on questao.idQuestao = lacuna.idQuestao ");
		select.append("inner join maiorTurma_Aluno turma on turma.chavePessoaAluno = aluno.chavePessoa ");
		select.append("inner join maiorTurma turmaGenerico on turmaGenerico.codigoTurma = turma.codigoTurma and turmaGenerico.codigoCurso = turma.codigoCurso and turmaGenerico.idDisciplina = turma.idDisciplina and turmaGenerico.ano = turma.ano and turmaGenerico.semestre = turma.semestre ");
		select.append("inner join maiorPessoa pessoaProfessor on turmaGenerico.chavePessoaProfessor = pessoaProfessor.chavePessoa ");
		select.append("where turma.codigoTurma='"+codigoTurma.toString()+"' and turma.codigoCurso="+codigoCurso.toString()+" ");
		select.append("and turma.idDisciplina="+idDisciplina.toString()+" and turma.ano="+ano.toString()+" and turma.semestre='"+semestre+"' ");
		
		if(chaveMonitor!=null && chaveMonitor.intValue()>0)
			select.append("and monitoria.chavePessoa="+chaveMonitor.toString()+" ");
		
		if(!VisaoQuestao.isStringVazia(idLista))
			select.append("and lista.idLista=? ");
		
		if(!VisaoQuestao.isStringVazia(semestre) || !VisaoQuestao.isStringVazia(ano.toString())){
			select.append("and resposta.dtSolucao>'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMinimoPorSemestre(semestre,ano.toString()))+"' ");
			select.append("and resposta.dtSolucao<'"+UtilDate.getDataInvertidaComoString(DominioSemestre.getValorDataMaximoPorSemestre(semestre,ano.toString()))+"' ");
		}
		if(dataInicial!=null){
			select.append("and resposta.dtSolucao>='"+UtilDate.getDataInvertidaComoString(dataInicial)+"' ");
		}
		if(dataFinal!=null){
			select.append("and resposta.dtSolucao<='"+UtilDate.getDataInvertidaComoString(dataFinal)+"' ");
		}
		select.append(" and (respostaAberta.correcao <> 'A' or respostaAberta.correcao is null) ");
		select.append("order by pessoa.nomePessoa, pessoa.chavePessoa");
		return select.toString();
	}
	
}