package questao.dao;

import java.sql.*;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.RespostaAlunoAvulsa_AbertaDTO;
import questao.slave.*;
import questao.validacao.apoio.ApoioResposta;
import questao.visao.VisaoQuestao;
import slave.Data;
import dao.DAOBase;

public class RespostaAlunoAvulsa_AbertaDAO extends DAOBase{
		
	private static final String SQL_ALTERARRESPOSTA = "UPDATE bdqRespostaAvulsa_Aberta set correcao = ? where idquestao = ? and chavepessoa = ? and dtSolucao = ? and horarioSolucao = ? ";
	private static final String SQL_DELETARRESPOSTA = "delete from bdqRespostaAvulsa_Aberta where idquestao = ? and chavepessoa = ? and dtSolucao = ? and horarioSolucao = ? ";
	private static final String SQL_CADASTRARQUESTAORESPOSTA = "insert into bdqRespostaAvulsa_Aberta values (?,?,?,?,?,?)";
//	private static final String SQL_CADASTRARQUESTAORESPOSTALISTA = "insert into bdqaluno_respostalista values (?,?,?,?,?,?,?)";
//	private static final String SQL_LISTARRESPOSTAAVULSA = "SELECT * FROM bdqAluno_RespostaAvulsa respAvulsa " +
//			"inner join bdqQuestao questao on questao.idQuestao=respAvulsa.idQuestao " +
//			"where respAvulsa.chavePessoa = ? ORDER BY respAvulsa.dtSolucao, respAvulsa.horarioSolucao ";
//	private static final String SQL_BUSCARQUESTAORESPOSTA = "SELECT * FROM BDQQUESTAO WHERE (IDQUESTAO = ?)";
//	private static final String SQL_BUSCARULTIMAQUESTAORESPOSTA = "SELECT MAX(IDQUESTAO) FROM BDQQUESTAO";
	public Collection buscaRespostasAvulsa_AbertaDoUsuario(Integer chaveUsuario, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException{
		String select = montaSelectRespostasAvulsa_Aberta(chaveUsuario,idDisciplina,idConteudo,ano,semestre);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setInt(1,chaveUsuario.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioResposta dto;
		while(rs.next()){
			dto = new ApoioResposta();
			putDtoApoioResposta(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col; 
	}
	
	public Collection buscaRespostasAbertaAvulsaDoUsuario(Integer chaveUsuario, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException{
		String select = montaSelectRespostasAvulsa_ApenasAberta(chaveUsuario,idDisciplina,idConteudo,ano,semestre);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setInt(1,chaveUsuario.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioResposta dto;
		while(rs.next()){
			dto = new ApoioResposta();
			putDtoApoioResposta(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col; 
	}
	
	private String montaSelectRespostasAvulsa_Aberta(Integer chaveUsuario, String idDisciplina, String idConteudo, String ano, String semestre) throws ParseException {
		StringBuffer select = new StringBuffer();
			select.append("SELECT * FROM bdqRespostaAvulsa_Aberta respAvulsa ");
			select.append("inner join bdqQuestao questao on questao.idQuestao=respAvulsa.idQuestao ");
			select.append("where respAvulsa.chavePessoa = "+chaveUsuario+" ");
			
			if(!VisaoQuestao.isStringVazia(idDisciplina))
				select.append("and questao.idDisciplina = "+idDisciplina+" ");
			
			if(!VisaoQuestao.isStringVazia(idConteudo))
				select.append("and questao.idConteudo = "+idConteudo+" ");
			
			if(!VisaoQuestao.isStringVazia(ano)){
				select.append("and questao.dtCriacao > "+DominioSemestre.getValorDataMinimoPorSemestre(semestre, ano)+" ");
				select.append("and questao.dtCriacao < "+DominioSemestre.getValorDataMaximoPorSemestre(semestre, ano)+" ");
			}
				
			select.append("ORDER BY respAvulsa.dtSolucao, respAvulsa.horarioSolucao ");
		return select.toString();
	}
	
	private String montaSelectRespostasAvulsa_ApenasAberta(Integer chaveUsuario, String idDisciplina, String idConteudo, String ano, String semestre) throws ParseException {
		StringBuffer select = new StringBuffer();
			select.append("SELECT * FROM bdqRespostaAvulsa_Aberta respAvulsa ");
			select.append("inner join bdqQuestao questao on questao.idQuestao=respAvulsa.idQuestao ");
			select.append("where respAvulsa.chavePessoa = "+chaveUsuario+"  and questao.tipoQuestao = "+DominioTipoQuestao.getValorDissertacao()+" ");
			
			if(!VisaoQuestao.isStringVazia(idDisciplina))
				select.append("and questao.idDisciplina = "+idDisciplina+" ");
			
			if(!VisaoQuestao.isStringVazia(idConteudo))
				select.append("and questao.idConteudo = "+idConteudo+" ");
			
			if(!VisaoQuestao.isStringVazia(ano)){
				if((ano.equals(new Integer(slave.Data.getAnoSystem()).toString()))&&((semestre.equals(new Integer(slave.Data.getSemestreSystem()).toString())))){
					select.append("and respAvulsa.dtSolucao > '"+Data.getDataInicioDoSemestre()+"' ");
					select.append("and respAvulsa.dtSolucao < '"+Data.getDataFinalDoSemestre()+"' ");
				}else{
					select.append("and respAvulsa.dtSolucao > '"+Data.getDataInicioDoSemestre(new Integer(ano), new Integer(semestre))+"' ");
					select.append("and respAvulsa.dtSolucao < '"+Data.getDataFinalDoSemestre(new Integer(ano), new Integer(semestre))+"' ");
				}
			}
				
			select.append("ORDER BY respAvulsa.dtSolucao, respAvulsa.horarioSolucao ");
			System.out.println("Executando a query das Correcoes: "+select.toString());
		return select.toString();
	}

	public ApoioResposta buscaRespostaAvulsa(Integer idQuestao, Integer chaveUsuario, Date dtSolucao, Time horarioSolucao) throws SQLException{
		String select = montaSelectAvulsa(idQuestao,chaveUsuario, dtSolucao,horarioSolucao);
		PreparedStatement ps = getConnection().prepareStatement(select);
		ps.setInt(1,idQuestao.intValue());
		ps.setInt(2,chaveUsuario.intValue());
		ps.setDate(3,UtilDate.getDateComoSqlDate(dtSolucao));
		ps.setTime(4,horarioSolucao);
		ResultSet rs = ps.executeQuery();
		ApoioResposta dto=null;
		if(rs.next()){
			dto = new ApoioResposta();
			putDtoApoioResposta(rs,dto);
		}
		rs.close();
		return dto;
	}
	
	private String montaSelectAvulsa(Integer idQuestao, Integer chaveUsuario, Date dtSolucao, Time horarioSolucao) {
		StringBuffer select = new StringBuffer();
			select.append("SELECT * FROM bdqRespostaAvulsa_Aberta respAvulsa ");
			select.append("inner join bdqQuestao questao on questao.idQuestao=respAvulsa.idQuestao ");
			select.append("where respAvulsa.idQuestao = ? ");
			select.append("and respAvulsa.chavePessoa = ? ");
			select.append("and respAvulsa.dtSolucao = ? ");
			select.append("and respAvulsa.horarioSolucao = ? ");
			select.append("ORDER BY respAvulsa.dtSolucao, respAvulsa.horarioSolucao ");
		return select.toString(); 
	}

	public void cadastrarQuestao(RespostaAlunoAvulsa_AbertaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARQUESTAORESPOSTA);
		ps.setInt(1,dto.getIdQuestao().intValue());
		ps.setInt(2,dto.getChavePessoa().intValue());
		ps.setDate(3,new java.sql.Date(dto.getDtSolucao().getTime()));
		ps.setTime(4,new Time(dto.getHorarioSolucao().getTime()));
		ps.setString(5,dto.getCorrecao());
		ps.setString(6,dto.getSolucao());
		
		ps.executeUpdate();
		ps.close();
	}
	
//	public void cadastrarQuestaoLista(RespostaAlunoListaDTO dto) throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_CADASTRARQUESTAORESPOSTALISTA);
//		ps.setInt(1,dto.getIdLista().intValue());
//		ps.setInt(2,dto.getIdQuestao().intValue());
//		ps.setInt(3,dto.getChavePessoa().intValue());
//		ps.setString(4,dto.getSolucao());
//		ps.setInt(5,dto.getTempoSolucao().intValue());
//		ps.setDate(6,UtilDate.getDateComoSqlDate(dto.getDtSolucao()));
//		ps.setTime(7,UtilDate.getDateComoSqlTime(dto.getHorarioSolucao()));
//		
//		ps.executeUpdate();
//		ps.close();
//	}
	
	public void excluirResposta(Integer idQuestao, Integer chavePessoa,Date dtSolucao, Time horarioSolucao) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARRESPOSTA);
		ps.setInt(1,idQuestao.intValue());
		ps.setInt(2,chavePessoa.intValue());
		ps.setDate(3,UtilDate.getDateComoSqlDate(dtSolucao));
		ps.setTime(4,horarioSolucao);
		ps.executeUpdate();
		ps.close();
	}
	
	public void corrigirResposta(String correcao, Integer idQuestao, Integer chavePessoa,Date dtSolucao, Time horarioSolucao) throws SQLException {

		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARRESPOSTA);
		ps.setString(1,correcao);
		ps.setInt(2,idQuestao.intValue());
		ps.setInt(3,chavePessoa.intValue());
		ps.setDate(4,UtilDate.getDateComoSqlDate(dtSolucao));
		ps.setTime(5,horarioSolucao);
		ps.executeUpdate();
		ps.close();
	}
	
//	public Integer buscarUltimoIdQuestao() throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARULTIMAQUESTAORESPOSTA);
//		ResultSet rs = ps.executeQuery();
//		Integer idQuestao = null;
//		if(rs.next())
//			idQuestao=new Integer(rs.getString(1));
//		rs.close();
//		ps.close();
//		return idQuestao;
//		
//	}
			
//	public QuestaoDTO buscarQuestao(Integer idQuestao) throws SQLException {
//		QuestaoDTO dto = new QuestaoDTO();
//
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARQUESTAORESPOSTA);
//		ps.setInt(1,idQuestao.intValue());
//		ResultSet rs = ps.executeQuery();
//		if(rs.next())
//			putDto(rs,dto);
//		rs.close();
//		ps.close();
//		return dto;
//		
//	}
	
//	public static void main(String[] args){
//		RespostaAlunoAvulsaDAO dao = new RespostaAlunoAvulsaDAO();
//		try {
//			Integer id = dao.buscarUltimoIdQuestao();
//			System.out.println(id);
//		} catch (SQLException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}
	
//	public void alterarQuestao(QuestaoDTO dto) throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_ALTERARRESPOSTA);
//		
//		ps.setInt(1,dto.getIdDisciplina().intValue());
//		ps.setInt(2,dto.getIdConteudo().intValue());
//		ps.setInt(3,dto.getChavePessoa().intValue());
//		ps.setString(4,dto.getEnunciado());
//		ps.setString(5,dto.getTipoQuestao());
//		ps.setString(6,dto.getDificuldade());
//		ps.setString(7,dto.getCategoria());
//		ps.setInt(8,dto.getTempo().intValue());
//		ps.setDate(9,new java.sql.Date(dto.getDtcriacao().getTime()));
//		ps.setInt(10,dto.getIdQuestao().intValue());
//		
//		ps.executeUpdate();
//		ps.close();
//	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	

//	public Collection buscarListaDeQuestoes(QuestaoDTO dtoTemp) throws SQLException {
//		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoes(dtoTemp);
//		PreparedStatement ps = con.prepareStatement(sql_buscarListaDeQuestoes);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
//	private String montaSelectListaDeQuestoes(QuestaoDTO dtoTemp) {
//		boolean temParteWhere = false;
//		StringBuffer select = new StringBuffer();
//		select.append("SELECT * FROM BDQQUESTAO questao ");
//		
//		//Tipo de questao (Outra tabela)
//		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idQuestao ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.idQuestao ");
//		}
//		
//		//Enunciado
//		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.enunciado like %"+dtoTemp.getEnunciado()+"% ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.enunciado like %"+dtoTemp.getEnunciado()+"% ");
//		}
//		
//		//Dificuldade
//		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.dificuldade ="+dtoTemp.getDificuldade()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.dificuldade ="+dtoTemp.getDificuldade()+" ");
//		}
//		
//		//Categoria
//		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.categoria ="+dtoTemp.getCategoria()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.categoria ="+dtoTemp.getCategoria()+" ");
//		}
//		
//		//Disciplina
//		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//		}
//		
//		//Conteudo
//		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//		}
//		return select.toString();
//	}

	public void putDtoApoioResposta(ResultSet rs, ApoioResposta dto) throws SQLException{
		dto.setChavePessoa(rs.getString("respAvulsa.chavePessoa"));
		dto.setDtSolucao(UtilDate.getDataComoString(rs.getDate("respAvulsa.dtSolucao")));
		dto.setEnunciado(rs.getString("questao.enunciado"));
		dto.setHorarioSolucao(UtilDate.getHoraCompletaComoString(rs.getTime("respAvulsa.horarioSolucao")));
		dto.setIdQuestao(rs.getString("respAvulsa.idQuestao"));
		dto.setSolucao(rs.getString("respAvulsa.solucao"));
		dto.setCorrecao(rs.getString("respAvulsa.correcao"));
//		dto.setTempoSolucao(rs.getString("respAvulsa.tempoSolucao"));
	}

}
