package questao.dao;

import java.sql.*;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

import questao.dto.RespostaAlunoLista_AbertaDTO;
import questao.slave.*;
import questao.validacao.apoio.ApoioResposta;
import questao.visao.VisaoQuestao;
import dao.DAOBase;

public class RespostaAlunoLista_AbertaDAO extends DAOBase{
		
    private static final String SQL_ALTERARRESPOSTA = "UPDATE bdqRespostaLista_Aberta set correcao = ? where idquestao = ? and chavepessoa = ? and idLista = ? ";
	private static final String SQL_DELETARRESPOSTA = "delete from bdqRespostaLista_Aberta where idquestao = ? and chavepessoa = ? and idLista = ? ";
//	private static final String SQL_CADASTRARQUESTAORESPOSTA = "insert into bdqaluno_respostaavulsa values (?,?,?,?,?,?)";
	private static final String SQL_CADASTRARQUESTAORESPOSTALISTA = "insert into bdqRespostaLista_Aberta values (?,?,?,?,?)";
//	private static final String SQL_LISTARRESPOSTALISTA = "SELECT * FROM bdqAluno_RespostaLista respLista " +
//	"inner join bdqQuestao questao on questao.idQuestao=respLista.idQuestao " +
//	"where respLista.chavePessoa = ? ORDER BY respLista.dtSolucao, respLista.horarioSolucao ";
//	private static final String SQL_BUSCARQUESTAORESPOSTA = "SELECT * FROM BDQQUESTAO WHERE (IDQUESTAO = ?)";
//	private static final String SQL_BUSCARULTIMAQUESTAORESPOSTA = "SELECT MAX(IDQUESTAO) FROM BDQQUESTAO";
	
	public Collection buscaRespostasListaDoUsuario(Integer chaveUsuario, String idLista, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException{
		String select = montaSelectRespostasLista(chaveUsuario,idLista,idDisciplina,idConteudo,ano,semestre);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setInt(1,chaveUsuario.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioResposta dto;
		while(rs.next()){
			dto = new ApoioResposta();
			putDtoApoioResposta(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	public Collection buscaRespostasAbertaListaDoUsuario(Integer chaveUsuario, String idLista, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException{
		String select = montaSelectRespostasAbertaLista(chaveUsuario,idLista,idDisciplina,idConteudo,ano,semestre);
		PreparedStatement ps = getConnection().prepareStatement(select);
//		ps.setInt(1,chaveUsuario.intValue());
		ResultSet rs = ps.executeQuery();
		Collection col = new ArrayList();
		ApoioResposta dto;
		while(rs.next()){
			dto = new ApoioResposta();
			putDtoApoioResposta(rs,dto);
			col.add(dto);
		}
		rs.close();
		return col;
	}
	
	private String montaSelectRespostasLista(Integer chaveUsuario, String idLista, String idDisciplina, String idConteudo, String ano, String semestre) throws ParseException {
		StringBuffer select = new StringBuffer();
			select.append("SELECT * FROM bdqRespostaLista_Aberta respLista ");
			select.append("inner join bdqQuestao questao on questao.idQuestao=respLista.idQuestao ");
			select.append("inner join bdqLista lista on lista.idLista=respLista.idLista ");
			select.append("where respLista.chavePessoa = "+chaveUsuario+" ");
			
			if(!VisaoQuestao.isStringVazia(idLista))
				select.append("and lista.idLista = "+idLista+" ");
			
			if(!VisaoQuestao.isStringVazia(idDisciplina))
				select.append("and questao.idDisciplina = "+idDisciplina+" ");
			
			if(!VisaoQuestao.isStringVazia(idConteudo))
				select.append("and questao.idConteudo = "+idConteudo+" ");
			
			if(!VisaoQuestao.isStringVazia(ano)){
				select.append("and questao.dtCriacao > "+DominioSemestre.getValorDataMinimoPorSemestre(semestre, ano)+" ");
				select.append("and questao.dtCriacao < "+DominioSemestre.getValorDataMaximoPorSemestre(semestre, ano)+" ");
			}
			
		return select.toString();
	}
	
	private String montaSelectRespostasAbertaLista(Integer chaveUsuario, String idLista, String idDisciplina, String idConteudo, String ano, String semestre) throws ParseException {
		StringBuffer select = new StringBuffer();
			select.append("SELECT * FROM bdqRespostaLista_Aberta respLista ");
			select.append("inner join bdqQuestao questao on questao.idQuestao=respLista.idQuestao ");
			select.append("inner join bdqLista lista on lista.idLista=respLista.idLista ");
			select.append("where respLista.chavePessoa = "+chaveUsuario+" and questao.tipoQuestao = "+DominioTipoQuestao.getValorDissertacao()+" ");
			
			if(!VisaoQuestao.isStringVazia(idLista))
				select.append("and lista.idLista = "+idLista+" ");
			
			if(!VisaoQuestao.isStringVazia(idDisciplina))
				select.append("and questao.idDisciplina = "+idDisciplina+" ");
			
			if(!VisaoQuestao.isStringVazia(idConteudo))
				select.append("and questao.idConteudo = "+idConteudo+" ");
			
			if(!VisaoQuestao.isStringVazia(ano)){
				select.append("and questao.dtCriacao > "+DominioSemestre.getValorDataMinimoPorSemestre(semestre, ano)+" ");
				select.append("and questao.dtCriacao < "+DominioSemestre.getValorDataMaximoPorSemestre(semestre, ano)+" ");
			}
			
		return select.toString();
	}

	//	public void cadastrarQuestao(RespostaAlunoAvulsaDTO dto) throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_CADASTRARQUESTAORESPOSTA);
//		ps.setInt(1,dto.getIdQuestao().intValue());
//		ps.setInt(2,dto.getChavePessoa().intValue());
//		ps.setString(3,dto.getSolucao());
//		ps.setInt(4,dto.getTempoSolucao().intValue());
//		ps.setDate(5,new java.sql.Date(dto.getDtSolucao().getTime()));
//		ps.setTime(6,new Time(dto.getHorarioSolucao().getTime()));
//		
//		ps.executeUpdate();
//		ps.close();
//	}
//	
	public void cadastrarQuestaoLista(RespostaAlunoLista_AbertaDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRARQUESTAORESPOSTALISTA);
		ps.setInt(1,dto.getIdLista().intValue());
		ps.setInt(2,dto.getIdQuestao().intValue());
		ps.setInt(3,dto.getChavePessoa().intValue());
		ps.setString(4,dto.getCorrecao());
		ps.setString(5,dto.getSolucao());
		
		ps.executeUpdate();
		ps.close();
	}
	
	public void excluirResposta(Integer idQuestao, Integer chavePessoa,Integer idLista) throws SQLException {
		//TODO: corrigir o excluir
		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETARRESPOSTA);
		ps.setInt(1,idQuestao.intValue());
		ps.setInt(2,chavePessoa.intValue());
		ps.setInt(3,idLista.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
	public void corrigirResposta(String correcao, Integer idQuestao, Integer chavePessoa,Integer idLista) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERARRESPOSTA);
		ps.setString(1,correcao);
		ps.setInt(2,idQuestao.intValue());
		ps.setInt(3,chavePessoa.intValue());
		ps.setInt(4,idLista.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
//	public Integer buscarUltimoIdQuestao() throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARULTIMAQUESTAORESPOSTA);
//		ResultSet rs = ps.executeQuery();
//		Integer idQuestao = null;
//		if(rs.next())
//			idQuestao=new Integer(rs.getString(1));
//		rs.close();
//		ps.close();
//		return idQuestao;
//		
//	}
			
//	public QuestaoDTO buscarQuestao(Integer idQuestao) throws SQLException {
//		QuestaoDTO dto = new QuestaoDTO();
//
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARQUESTAORESPOSTA);
//		ps.setInt(1,idQuestao.intValue());
//		ResultSet rs = ps.executeQuery();
//		if(rs.next())
//			putDto(rs,dto);
//		rs.close();
//		ps.close();
//		return dto;
//		
//	}
	
//	public static void main(String[] args){
//		RespostaAlunoAvulsaDAO dao = new RespostaAlunoAvulsaDAO();
//		try {
//			Integer id = dao.buscarUltimoIdQuestao();
//			System.out.println(id);
//		} catch (SQLException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}
	
//	public void alterarQuestao(QuestaoDTO dto) throws SQLException {
//		PreparedStatement ps = con.prepareStatement(SQL_ALTERARRESPOSTA);
//		
//		ps.setInt(1,dto.getIdDisciplina().intValue());
//		ps.setInt(2,dto.getIdConteudo().intValue());
//		ps.setInt(3,dto.getChavePessoa().intValue());
//		ps.setString(4,dto.getEnunciado());
//		ps.setString(5,dto.getTipoQuestao());
//		ps.setString(6,dto.getDificuldade());
//		ps.setString(7,dto.getCategoria());
//		ps.setInt(8,dto.getTempo().intValue());
//		ps.setDate(9,new java.sql.Date(dto.getDtcriacao().getTime()));
//		ps.setInt(10,dto.getIdQuestao().intValue());
//		
//		ps.executeUpdate();
//		ps.close();
//	}
	
//	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
//		String SQL_BUSCARTURMASPORCODIGOEDISCIPLINA = "SELECT * FROM BDQQUESTAO WHERE ENUNCIADO LIKE '%"+enunciado+"%' ORDER BY ENUNCIADO;";
//		PreparedStatement ps = con.prepareStatement(SQL_BUSCARTURMASPORCODIGOEDISCIPLINA);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	

//	public Collection buscarListaDeQuestoes(QuestaoDTO dtoTemp) throws SQLException {
//		String sql_buscarListaDeQuestoes = montaSelectListaDeQuestoes(dtoTemp);
//		PreparedStatement ps = con.prepareStatement(sql_buscarListaDeQuestoes);
//		ResultSet rs = ps.executeQuery();
//		Collection col = new ArrayList();
//		QuestaoDTO dto;
//		while(rs.next()){
//			dto = new QuestaoDTO();
//			putDto(rs,dto);
//			col.add(dto);
//		}
//		rs.close();
//		return col;
//	}
	
//	private String montaSelectListaDeQuestoes(QuestaoDTO dtoTemp) {
//		boolean temParteWhere = false;
//		StringBuffer select = new StringBuffer();
//		select.append("SELECT * FROM BDQQUESTAO questao ");
//		
//		//Tipo de questao (Outra tabela)
//		if(dtoTemp.getTipoQuestao()!=null && !dtoTemp.getTipoQuestao().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idQuestao ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.idQuestao ");
//		}
//		
//		//Enunciado
//		if(dtoTemp.getEnunciado()!=null && !dtoTemp.getEnunciado().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.enunciado like %"+dtoTemp.getEnunciado()+"% ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.enunciado like %"+dtoTemp.getEnunciado()+"% ");
//		}
//		
//		//Dificuldade
//		if(dtoTemp.getDificuldade()!=null && !dtoTemp.getDificuldade().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.dificuldade ="+dtoTemp.getDificuldade()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.dificuldade ="+dtoTemp.getDificuldade()+" ");
//		}
//		
//		//Categoria
//		if(dtoTemp.getCategoria()!=null && !dtoTemp.getCategoria().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.categoria ="+dtoTemp.getCategoria()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.categoria ="+dtoTemp.getCategoria()+" ");
//		}
//		
//		//Disciplina
//		if(dtoTemp.getIdDisciplina()!=null && !dtoTemp.getIdDisciplina().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.idDisciplina ="+dtoTemp.getIdDisciplina()+" ");
//		}
//		
//		//Conteudo
//		if(dtoTemp.getIdConteudo()!=null && !dtoTemp.getIdConteudo().equals("")){
//			if(!temParteWhere){
//				select.append(" where questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//				temParteWhere=true;
//			}
//			select.append(" and questao.idConteudo ="+dtoTemp.getIdConteudo()+" ");
//		}
//		return select.toString();
//	}
	
	public ApoioResposta buscaRespostaLista(Integer idQuestao, Integer chaveUsuario, Integer idLista) throws SQLException{
		String select = montaSelectLista(idQuestao,chaveUsuario);
		PreparedStatement ps = getConnection().prepareStatement(select);
		ps.setInt(1,idQuestao.intValue());
		ps.setInt(2,chaveUsuario.intValue());
		ps.setInt(3,idLista.intValue());
		ResultSet rs = ps.executeQuery();
		ApoioResposta dto=null;
		if(rs.next()){
			dto = new ApoioResposta();
			putDtoApoioResposta(rs,dto);
		}
		rs.close();
		return dto;
	}
	
	private String montaSelectLista(Integer idQuestao, Integer chaveUsuario) {
		StringBuffer select = new StringBuffer();
			select.append("SELECT * FROM bdqRespostaLista_Aberta respLista ");
			select.append("inner join bdqQuestao questao on questao.idQuestao=respLista.idQuestao ");
			select.append("where respLista.idQuestao = ? ");
			select.append("and respLista.chavePessoa = ? ");
			select.append("and respLista.idLista = ? ");
		return select.toString(); 
	}

	public void putDtoApoioResposta(ResultSet rs, ApoioResposta dto) throws SQLException{
		dto.setChavePessoa(rs.getString("respLista.chavePessoa"));
		dto.setEnunciado(rs.getString("questao.enunciado"));
		dto.setIdQuestao(rs.getString("respLista.idQuestao"));
		dto.setSolucao(rs.getString("respLista.solucao"));
		dto.setIdLista(rs.getString("respLista.idLista"));
		dto.setCorrecao(rs.getString("respLista.correcao"));
	}

}
