/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.*;

import model.ModelBase;

import questao.dao.*;
import questao.dto.*;
import questao.validacao.apoio.ApoioLista;
import dao.DAOFactory;
import dto.LoginDTO;
import dto.TurmaDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class ListaModel extends ModelBase{
	private ListaDAO dao;
	private ListaQuestaoDAO daoListaQuestao;
	private ListaTurmaDAO daoListaTurma;
	
	public ListaModel(LoginDTO login) {
		super(login);
	}

	public Collection listarTodasListas() throws SQLException {
		Collection result;
		abreConexao(getDao(),dao);
		result =  dao.listarTodasListas();
		fechaConexao(dao);
		return result;
	}

	public void cadastrarLista(ListaDTO dto, List listaQuestoes)
			throws SQLException {
		getDao();
		getDaoListaQuestao();
		dao.cadastrarLista(dto);
		Integer idLista = dao.buscarUltimoIdLista();
		Iterator it = listaQuestoes.iterator();
		
		while(it.hasNext()){
			QuestaoDTO questaoTemp = (QuestaoDTO)it.next();
			daoListaQuestao.cadastrarLista(idLista,questaoTemp.getIdQuestao());
		}
		fechaConexao(dao);
		fechaConexao(daoListaQuestao);
	}
	
	public void cadastrarListaTurma(TurmaDTO dto, Integer idLista, Date dtLimiteEntrega, Date horarioLimiteEntrega)
			throws SQLException {
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		getDaoListaTurma().cadastrarListaTurma(dto,idLista,dtLimiteEntrega,horarioLimiteEntrega);
		fechaConexao(daoListaTurma);
	}
	
	public void excluir(Integer idLista) throws SQLException {
		getDao();
		getDaoListaQuestao();
		daoListaQuestao.excluirLista(idLista);
		dao.excluirLista(idLista);
		fechaConexao(dao);
		fechaConexao(daoListaQuestao);
	}
	
	public void excluirListaDaTurma(Integer idLista, TurmaDTO turma) throws SQLException {
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		getDaoListaTurma().excluirListaDaTurma(idLista,turma);
		fechaConexao(daoListaTurma);
	}

	public ListaDTO buscarLista(Integer idLista) throws SQLException {
//		abreConexao(getDao(),dao);
		ListaDTO dto;
		dto = getDao().buscarLista(idLista);
		fechaConexao(dao);
		return dto;	

	}
	
	public ApoioLista buscarListaApoioLista(Integer idLista) throws SQLException {
//		abreConexao(getDao(),dao);
		ApoioLista apoio;
		apoio = getDao().buscarListaApoioLista(idLista);
		fechaConexao(dao);
		return apoio;	
	}

	public void alterarLista(ListaDTO dto) throws SQLException {
//		abreConexao(getDao(),dao);
		getDao().alterarLista(dto);
		fechaConexao(dao);
	}

	public Collection buscarListaPorTitulo(String titulo) throws SQLException {
//		abreConexao(getDao(),dao);
		Collection result;
		result = getDao().buscarListaPorTitulo(titulo);
		fechaConexao(dao);
		return result;
	}
	
	public Collection buscarListaDaTurma(TurmaDTO dtoTurma) throws ParseException, SQLException {
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		Collection result;
		result = getDaoListaTurma().buscarListaPorTitulo(dtoTurma);
		fechaConexao(daoListaTurma);
		return result;
	}
	
	public ListaTurmaDTO buscarListaDaTurmaPorId(String idLista, TurmaDTO dtoTurma) throws ParseException, SQLException {
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		ListaTurmaDTO dto;
		dto = getDaoListaTurma().buscarListaDaTurmaPorId(idLista, dtoTurma);
		fechaConexao(daoListaTurma);
		return dto;	
	}
	
	public Collection buscarTodasListaETurmas()  throws ParseException, SQLException{
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		Collection result;
		result = getDaoListaTurma().buscarTodasListaETurmas();
		fechaConexao(daoListaTurma);
		return result;
	}
	
	public Collection buscarTodasListaETurmasDoAluno(String chaveAluno)  throws ParseException, SQLException{
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		Collection result;
		result = getDaoListaTurma().buscarTodasListaETurmasEChaveAluno(chaveAluno);
		fechaConexao(daoListaTurma);
		return result;
	}

	public Collection buscarTodasListaETurmasDoAlunoNoSemestreCorrente(String chaveAluno)  throws ParseException, SQLException{
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		Collection result;
		result = getDaoListaTurma().buscarTodasListaETurmasEChaveAlunoNoSemestreCorrente(chaveAluno);
		fechaConexao(daoListaTurma);
		return result;
	}
	
	public ListaTurmaDTO buscaDataLimiteParaLista(ListaDTO lista, String chaveAluno)  throws ParseException, SQLException{
//		abreConexao(getDaoListaTurma(), daoListaTurma);
		ListaTurmaDTO dto;
		dto = getDaoListaTurma().buscaDataLimiteParaLista(lista,chaveAluno);
		fechaConexao(daoListaTurma);
		return dto;
	}

	public ListaDAO getDao() throws SQLException {
//		if (this.dao == null)
			try {
				this.dao = (ListaDAO) DAOFactory.getInstance().getDAO("questao.dao.ListaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.dao;
	}
	
	public ListaQuestaoDAO getDaoListaQuestao() throws SQLException {
//		if (this.daoListaQuestao == null)
			try {
				this.daoListaQuestao = (ListaQuestaoDAO) DAOFactory.getInstance().getDAO("questao.dao.ListaQuestaoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoListaQuestao;
	}
	
	public ListaTurmaDAO getDaoListaTurma() throws SQLException {
//		if (this.daoListaTurma == null)
			try {
				this.daoListaTurma = (ListaTurmaDAO) DAOFactory.getInstance().getDAO("questao.dao.ListaTurmaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoListaTurma;
	}
	
}