/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.model;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import model.ModelBase;

import questao.dao.*;
import questao.dto.*;
import questao.slave.DominioTipoQuestao;
import questao.validacao.apoio.ApoioQuestao;
import dao.DAOFactory;
import dto.LoginDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class QuestaoModel extends ModelBase{
	private QuestaoDAO dao;
	private ComplementoVouFDAO daoVouF;
	private ComplementoMultiplaDAO daoMultipla;
	private ComplementoEscolhaDAO daoEscolha;
	private ComplementoLacunaDAO daoLacuna;
	private ComplementoAbertaDAO daoAberta;

	public QuestaoModel(LoginDTO login) {
		super(login);
	}

	//Cadastrar
	public void cadastrarQuestao(QuestaoDTO dto, IComplementoQuestao complemento)
	throws SQLException {
		getDao();
		getDaoVouF();
		getDaoMultipla();
		getDaoEscolha();
		getDaoLacuna();
		getDaoAberta();
		
		dao.cadastrarQuestao(dto);

		//TODO: alterar a forma de buscar o ultimo id da questo para evitar futuros erros de sicronizao

		if (complemento instanceof ComplementoVouFDTO) {
			ComplementoVouFDTO compVouFTemp = (ComplementoVouFDTO) complemento;
			compVouFTemp.setIdQuestao(dao.buscarUltimoIdQuestao());
			daoVouF.cadastrarComplemento(compVouFTemp);
		}else if (complemento instanceof ComplementoMultiplaDTO) {
			ComplementoMultiplaDTO compMultiplaTemp = (ComplementoMultiplaDTO) complemento;
			compMultiplaTemp.setIdQuestao(dao.buscarUltimoIdQuestao());
			daoMultipla.cadastrarComplemento(compMultiplaTemp);
		}else if (complemento instanceof ComplementoEscolhaDTO) {
			ComplementoEscolhaDTO compEscolhaTemp = (ComplementoEscolhaDTO) complemento;
			compEscolhaTemp.setIdQuestao(dao.buscarUltimoIdQuestao());
			daoEscolha.cadastrarComplemento(compEscolhaTemp);
		}else if (complemento instanceof ComplementoLacunaDTO) {
			ComplementoLacunaDTO compLacunaTemp = (ComplementoLacunaDTO) complemento;
			compLacunaTemp.setIdQuestao(dao.buscarUltimoIdQuestao());
			daoLacuna.cadastrarComplemento(compLacunaTemp);
		}else if (complemento instanceof ComplementoAbertaDTO) {
			ComplementoAbertaDTO compAbertaTemp = (ComplementoAbertaDTO) complemento;
			compAbertaTemp.setIdQuestao(dao.buscarUltimoIdQuestao());
			daoAberta.cadastrarComplemento(compAbertaTemp);
		}
		fechaConexao(dao);
		fechaConexao(daoVouF);
		fechaConexao(daoMultipla);
		fechaConexao(daoEscolha);
		fechaConexao(daoLacuna);
		fechaConexao(daoAberta);

	}

	//Buscas 
	public Collection listarTodasQuestoes() throws SQLException {
		Collection list ;
		list = getDao().listarTodasQuestoes();
		fechaConexao(dao);
		return list;
	}
	public QuestaoDTO buscarQuestao(Integer idQuestao) throws SQLException {
		QuestaoDTO dto ;
//		abreConexao(getDao(),dao);
		dto = getDao().buscarQuestao(idQuestao);
		fechaConexao(dao);
		return dto;
	}
	public ApoioQuestao buscarQuestaoApoioQuestao(Integer idQuestao) throws SQLException {
		ApoioQuestao apoio ;
//		abreConexao(getDao(),dao);
		apoio = getDao().buscarQuestaoApoio(idQuestao);
		fechaConexao(dao);
		return apoio;
	}
	public ComplementoVouFDTO buscaComplementoVouF(Integer idQuestao) throws SQLException {
		ComplementoVouFDTO dto ;
//		abreConexao(getDaoVouF(), daoVouF);
		dto = getDaoVouF().buscarComplemento(idQuestao);
		fechaConexao(daoVouF);
		return dto;
	}
	public ComplementoMultiplaDTO buscaComplementoMultipla(Integer idQuestao) throws SQLException {
		ComplementoMultiplaDTO dto ;
		abreConexao(getDaoMultipla(), daoMultipla);
		dto = daoMultipla.buscarComplemento(idQuestao);
		fechaConexao(daoMultipla);
		return dto;
	}
	public ComplementoEscolhaDTO buscaComplementoEscolha(Integer idQuestao) throws SQLException {
		ComplementoEscolhaDTO dto ;
		abreConexao(getDaoEscolha(), daoEscolha);
		dto = daoEscolha.buscarComplemento(idQuestao);
		fechaConexao(daoEscolha);
		return dto;
	}
	public ComplementoLacunaDTO buscaComplementoLacuna(Integer idQuestao) throws SQLException {
		ComplementoLacunaDTO dto ;
		abreConexao(getDaoLacuna(), daoLacuna);
		dto = daoLacuna.buscarComplemento(idQuestao);
		fechaConexao(daoLacuna);
		return dto;
	}
	public ComplementoAbertaDTO buscaComplementoAberta(Integer idQuestao) throws SQLException {
		ComplementoAbertaDTO dto ;
		abreConexao(getDaoAberta(), daoAberta);
		dto = daoAberta.buscarComplemento(idQuestao);
		fechaConexao(daoAberta);
		return dto;
	}
	public Collection buscarQuestoesPorEnunciado(String enunciado) throws SQLException {
		Collection list ;
//		abreConexao(getDao(),dao);
		list = getDao().buscarQuestoesPorEnunciado(enunciado);
		fechaConexao(dao);
		return list;
	}
	public List buscarListaDeQuestoes(QuestaoDTO dto) throws SQLException {
		List list ;
//		abreConexao(getDao(),dao);
		list = getDao().buscarListaDeQuestoes(dto);
		fechaConexao(dao);
		return list;
	}
	public int buscarQuantidadeListaDeQuestoes(QuestaoDTO dto) throws SQLException {
		int list ;
//		abreConexao(getDao(),dao);
		list = getDao().buscarQuantidadeListaDeQuestoes(dto);
		fechaConexao(dao);
		return list;
	}
	public List buscarListaDeQuestoes(QuestaoDTO dto, Integer perfil, Integer chavePessoa ) throws SQLException {
		List list ;
//		dao = getDao();
		System.out.println("qst Modl - foi buscar");
		list = getDao().buscarListaDeQuestoes(dto, perfil, chavePessoa);
		fechaConexao(dao);
		return list;
	}
	public List buscarListaDeQuestoesApoioQuestao(QuestaoDTO dto) throws SQLException {
		List list ;
//		abreConexao(getDao(),dao);
		list = getDao().buscarListaDeQuestoesApoioQuestao(dto);
		fechaConexao(dao);
		return list;
	}
	public List buscarListaDeQuestoes(ListaDTO dto, Integer chavePessoa) throws SQLException {
		List list ;
//		abreConexao(getDao(),dao);
		list = getDao().buscarListaDeQuestoes(dto,chavePessoa);
		fechaConexao(dao);
		return list;
	}

	//Excluso
	public void excluirQuestao(Integer idQuestao) throws SQLException {


		getDao();
		getDaoVouF();
		getDaoMultipla();
		getDaoEscolha();
		getDaoLacuna();
		getDaoAberta();

		QuestaoDTO questao = dao.buscarQuestao(idQuestao);

		if(questao.getTipoQuestao().equalsIgnoreCase(DominioTipoQuestao.getValorVouF()))
			daoVouF.excluirComplemento(idQuestao);

		if(questao.getTipoQuestao().equalsIgnoreCase(DominioTipoQuestao.getValorMultiplaEscolha()))
			daoMultipla.excluirComplemento(idQuestao);

		if(questao.getTipoQuestao().equalsIgnoreCase(DominioTipoQuestao.getValorEscolhaMultipla()))
			daoEscolha.excluirComplemento(idQuestao);

		if(questao.getTipoQuestao().equalsIgnoreCase(DominioTipoQuestao.getValorLacunas()))
			daoLacuna.excluirComplemento(idQuestao);

		if(questao.getTipoQuestao().equalsIgnoreCase(DominioTipoQuestao.getValorDissertacao()))
			daoAberta.excluirComplemento(idQuestao);

		dao.excluirQuestao(idQuestao);
		fechaConexao(dao);
		fechaConexao(daoVouF);
		fechaConexao(daoMultipla);
		fechaConexao(daoEscolha);
		fechaConexao(daoLacuna);
		fechaConexao(daoAberta);
	}

	//Alterao
	public void alterarQuestao(QuestaoDTO dto,IComplementoQuestao complemento) throws SQLException {

		getDao();
		getDaoVouF();
		getDaoMultipla();
		getDaoEscolha();
		getDaoLacuna();
		getDaoAberta();
		dao.alterarQuestao(dto);

		//TODO: alterar a forma de buscar o ultimo id da questo para evitar futuros erros de sicronizao

		if (complemento instanceof ComplementoVouFDTO) {
			ComplementoVouFDTO compVouFTemp = (ComplementoVouFDTO) complemento;
			daoVouF.alterarComplemento(compVouFTemp);
		}else if (complemento instanceof ComplementoMultiplaDTO) {
			ComplementoMultiplaDTO compMultiplaTemp = (ComplementoMultiplaDTO) complemento;
			daoMultipla.alterarComplemento(compMultiplaTemp);
		}else if (complemento instanceof ComplementoEscolhaDTO) {
			ComplementoEscolhaDTO compEscolhaTemp = (ComplementoEscolhaDTO) complemento;
			daoEscolha.alterarComplemento(compEscolhaTemp);
		}else if (complemento instanceof ComplementoLacunaDTO) {
			ComplementoLacunaDTO compLacunaTemp = (ComplementoLacunaDTO) complemento;
			daoLacuna.alterarComplemento(compLacunaTemp);
		}else if (complemento instanceof ComplementoAbertaDTO) {
			ComplementoAbertaDTO compAbertaTemp = (ComplementoAbertaDTO) complemento;
			daoAberta.alterarComplemento(compAbertaTemp);
		}
		fechaConexao(dao);
		fechaConexao(daoVouF);
		fechaConexao(daoMultipla);
		fechaConexao(daoEscolha);
		fechaConexao(daoLacuna);
		fechaConexao(daoAberta);

	}



	//############################### DAO'S ############################
	public QuestaoDAO getDao() throws SQLException {
//		if (this.dao == null)
			try {
				this.dao = (QuestaoDAO) DAOFactory.getInstance().getDAO("questao.dao.QuestaoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return this.dao;
	}

	public ComplementoVouFDAO getDaoVouF() throws SQLException {
//		if (this.daoVouF == null)
			try {
				this.daoVouF = (ComplementoVouFDAO) DAOFactory.getInstance().getDAO("questao.dao.ComplementoVouFDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return this.daoVouF;
	}

	public ComplementoMultiplaDAO getDaoMultipla() throws SQLException {
//		if (this.daoMultipla == null)
			try {
				this.daoMultipla = (ComplementoMultiplaDAO) DAOFactory.getInstance().getDAO("questao.dao.ComplementoMultiplaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return this.daoMultipla;
	}

	public ComplementoEscolhaDAO getDaoEscolha() throws SQLException {
//		if (this.daoEscolha == null)
			try {
				this.daoEscolha = (ComplementoEscolhaDAO) DAOFactory.getInstance().getDAO("questao.dao.ComplementoEscolhaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return this.daoEscolha;
	}

	public ComplementoLacunaDAO getDaoLacuna() throws SQLException {
//		if (this.daoLacuna == null)
			try {
				this.daoLacuna = (ComplementoLacunaDAO) DAOFactory.getInstance().getDAO("questao.dao.ComplementoLacunaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return this.daoLacuna;
	}

	public ComplementoAbertaDAO getDaoAberta() throws SQLException {
//		if (this.daoAberta == null)
			try {
				this.daoAberta = (ComplementoAbertaDAO) DAOFactory.getInstance().getDAO("questao.dao.ComplementoAbertaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return this.daoAberta;
	}

}