/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

import model.ModelBase;

import questao.dao.*;
import questao.dto.*;
import sun.reflect.ReflectionFactory.GetReflectionFactoryAction;
import dao.DAOFactory;
import dto.LoginDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class RelatorioModel extends ModelBase{
	private RelatorioAlunoDAO daoAluno;
	private RelatorioTurmaDAO daoTurma;
	private RelatorioDisciplinaDAO daoDisciplina;
	
	public RelatorioModel(LoginDTO login) {
		super(login);
	}
	
	public RelatorioAlunoDTO buscarRelatorioAlunoPorChaveAluno(Integer chaveAluno,String idLista, String idDisciplina, String idConteudo, String semestre, String ano, String listaOuQuestao, Integer perfil, String busca, Date dataInicial, Date dataFinal)  throws SQLException, ParseException{
		RelatorioAlunoDTO dto;
//		abreConexao(getDaoRelatorioAluno(), daoAluno);
		dto = getDaoRelatorioAluno().buscarTodoHistoricoDoAluno(chaveAluno, idLista, idDisciplina, idConteudo,semestre, ano,listaOuQuestao, perfil, busca,dataInicial,dataFinal);
		fechaConexao(daoAluno);
		return dto;
	}
	
	public RelatorioAlunoDTO buscarRelatorioAlunoPorChaveAlunoPerfilMonitor(Integer chaveAluno,String idLista, String idDisciplina, String idConteudo, String semestre, String ano, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal)  throws SQLException, ParseException{
		RelatorioAlunoDTO dto;
//		abreConexao(getDaoRelatorioAluno(),daoAluno);
		dto = getDaoRelatorioAluno().buscarTodoHistoricoDoAlunoPerfilMonitor(chaveAluno, idLista, idDisciplina, idConteudo,semestre, ano,listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		fechaConexao(daoAluno);
		return dto;
	}
	 
	public RelatorioTurmaDTO buscarRelatorioTurmaPorCodigoDaTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String idLista, String listaOuQuestao, Date dataInicial, Date dataFinal)  throws SQLException, ParseException{
		RelatorioTurmaDTO dto;
//		abreConexao(getDaoRelatorioTurma(), daoTurma);
		dto = getDaoRelatorioTurma().buscarDadosDaTurmaPorCodigoDaTurma(codigoTurma,codigoCurso, idDisciplina, ano, semestre, idLista, listaOuQuestao,dataInicial,dataFinal);
		fechaConexao(daoTurma);
		return dto;
	}
	
	public RelatorioTurmaDTO buscarRelatorioTurmaPorCodigoDaTurmaPerfilMonitor(String codigoTurma, Integer codigoCurso, Integer idDisciplina, Integer ano, String semestre, String idLista, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal)  throws SQLException, ParseException{
		RelatorioTurmaDTO dto;
//		abreConexao(getDaoRelatorioAluno(),daoTurma);
		dto = getDaoRelatorioTurma().buscarDadosDaTurmaPorCodigoDaTurmaPerfilMonitor(codigoTurma,codigoCurso, idDisciplina, ano, semestre, idLista, listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		fechaConexao(daoTurma);
		return dto;
	}
	
	public RelatorioDisciplinaDTO buscarRelatorioDisciplinaPorIdDisciplina(Integer idDisciplina,String idConteudo, Integer ano, String semestre, String idLista, String listaOuQuestao, Date dataInicial, Date dataFinal)  throws SQLException, ParseException{
		RelatorioDisciplinaDTO dto;
//		abreConexao(getDaoRelatorioDisciplina(),daoDisciplina);
		dto = getDaoRelatorioDisciplina().buscarRelatorioDisciplinaPorIdDisciplina(idDisciplina, idConteudo, ano, semestre, idLista, listaOuQuestao,dataInicial,dataFinal);
		fechaConexao(daoDisciplina);
		return dto;
	}
	 
	public RelatorioDisciplinaDTO buscarRelatorioDisciplinaPorIdDisciplinaPerfilMonitor(Integer idDisciplina,String idConteudo, Integer ano, String semestre, String idLista, String listaOuQuestao, Integer chaveMonitor, Date dataInicial, Date dataFinal)  throws SQLException, ParseException{
		RelatorioDisciplinaDTO dto;
//		abreConexao(getDaoRelatorioDisciplina(),daoDisciplina);
		dto = getDaoRelatorioDisciplina().buscarRelatorioDisciplinaPorIdDisciplinaPerfilMonitor(idDisciplina,idConteudo, ano, semestre, idLista, listaOuQuestao, chaveMonitor,dataInicial,dataFinal);
		fechaConexao(daoDisciplina);
		return dto;
	}

	public RelatorioAlunoDAO getDaoRelatorioAluno() throws SQLException {
//		if (this.daoAluno == null)
			try {
				this.daoAluno = (RelatorioAlunoDAO) DAOFactory.getInstance().getDAO("questao.dao.RelatorioAlunoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
		return this.daoAluno;
	}
	
	public RelatorioTurmaDAO getDaoRelatorioTurma() throws SQLException {
//		if (this.daoTurma == null)
			try {
				this.daoTurma = (RelatorioTurmaDAO) DAOFactory.getInstance().getDAO("questao.dao.RelatorioTurmaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
		return this.daoTurma;
	}
	
	public RelatorioDisciplinaDAO getDaoRelatorioDisciplina() throws SQLException {
//		if (this.daoDisciplina == null)
			try {
				this.daoDisciplina = (RelatorioDisciplinaDAO) DAOFactory.getInstance().getDAO("questao.dao.RelatorioDisciplinaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
		return this.daoDisciplina;
	}

}