/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.model;

import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;

import model.ModelBase;

import questao.dao.*;
import questao.dao.RespostaAlunoAvulsaDAO;
import questao.dao.RespostaAlunoListaDAO;
import questao.dto.*;
import questao.dto.RespostaAlunoAvulsaDTO;
import questao.dto.RespostaAlunoListaDTO;
import questao.slave.*;
import questao.slave.DominioGabaritoQuestao;
import questao.slave.UtilDate;
import questao.validacao.apoio.ApoioResposta;
import dao.DAOFactory;
import dto.LoginDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class RespostaModel extends ModelBase{
	private RespostaAlunoAvulsaDAO daoRespostaAvulsa;
	private RespostaAlunoListaDAO daoRespostaLista;
	private RespostaAlunoAvulsa_AbertaDAO daoRespostaAvulsa_Aberta;
	private RespostaAlunoLista_AbertaDAO daoRespostaLista_Aberta;
	
	public RespostaModel(LoginDTO login) {
		super(login);
	}

//	public Collection listarTodasQuestoes() throws SQLException {
//		return (getDao().listarTodasQuestoes());
//	}

	public void cadastrarResposta(RespostaAlunoAvulsaDTO dto)
			throws SQLException {
		
		getDaoRespostaAvulsa().cadastrarQuestao(dto);
		fechaConexao(daoRespostaAvulsa);
	}
	
	public void cadastrarResposta_Aberta(RespostaAlunoAvulsa_AbertaDTO dto)
			throws SQLException {
		//TODO: codigo provisorio apenas para no dar erro no banco no estado atual que ele esta criado, retirar essa parte do codigo depois
//		getDaoRespostaAvulsa();
//		getDaoRespostaAvulsa_Aberta();
		
		RespostaAlunoAvulsaDTO resp = new RespostaAlunoAvulsaDTO();
		resp.setChavePessoa(dto.getChavePessoa());
		resp.setDtSolucao(dto.getDtSolucao());
		resp.setHorarioSolucao(dto.getHorarioSolucao());
		resp.setIdQuestao(dto.getIdQuestao());
		resp.setSolucao(DominioGabaritoQuestao.VALOR_LACUNA_RESPONDIDA);
		resp.setTempoSolucao(dto.getTempoSolucao());
		getDaoRespostaAvulsa().cadastrarQuestao(resp);
		//#################################################
		
		getDaoRespostaAvulsa_Aberta().cadastrarQuestao(dto);
		fechaConexao(daoRespostaAvulsa);
		fechaConexao(daoRespostaAvulsa_Aberta);
	}

	public void cadastrarRespostaLista(RespostaAlunoListaDTO dto)
			throws SQLException {
		getDaoRespostaLista().cadastrarQuestaoLista(dto);
		fechaConexao(daoRespostaLista);
	}
	
	public void cadastrarRespostaLista_Aberta(RespostaAlunoLista_AbertaDTO dto)
			throws SQLException {
//		TODO: codigo provisorio apenas para no dar erro no banco no estado atual que ele esta criado, retirar essa parte do codigo depois
		RespostaAlunoListaDTO resp = new RespostaAlunoListaDTO();
		resp.setChavePessoa(dto.getChavePessoa());
		resp.setDtSolucao(dto.getDtSolucao());
		resp.setHorarioSolucao(dto.getHorarioSolucao());
		resp.setIdQuestao(dto.getIdQuestao());
		resp.setSolucao(DominioGabaritoQuestao.VALOR_LACUNA_RESPONDIDA);
		resp.setTempoSolucao(dto.getTempoSolucao());
		resp.setIdLista(dto.getIdLista());
		
//		abreConexao(getDaoRespostaLista(), daoRespostaLista);
//		abreConexao(getDaoRespostaLista_Aberta(), daoRespostaLista_Aberta);
	
		getDaoRespostaLista().cadastrarQuestaoLista(resp);
		//#################################################
		
		getDaoRespostaLista_Aberta().cadastrarQuestaoLista(dto);
		fechaConexao(daoRespostaLista);
		fechaConexao(daoRespostaLista_Aberta);
	}

	public Collection buscaRespostasAvulsaDoUsuario(Integer chaveUsuario, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException {
		Collection result;
//		abreConexao(getDaoRespostaAvulsa(), daoRespostaAvulsa);
		result = getDaoRespostaAvulsa().buscaRespostasAvulsaDoUsuario(chaveUsuario,idDisciplina,idConteudo,ano,semestre);
		fechaConexao(daoRespostaAvulsa);
		return result;
	}
	
	public Collection buscaRespostasAbertaAvulsaDoUsuario(Integer chaveUsuario, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException {
		Collection result;
//		abreConexao(getDaoRespostaAvulsa_Aberta(), daoRespostaAvulsa_Aberta);
		result = getDaoRespostaAvulsa_Aberta().buscaRespostasAbertaAvulsaDoUsuario(chaveUsuario,idDisciplina,idConteudo,ano,semestre);
		fechaConexao(daoRespostaAvulsa_Aberta);
		return result;
		
	}
	
	public ApoioResposta buscaRespostaAvulsa(Integer idQuestao, Integer chaveUsuario, Date dtSolucao, Time horarioSolucao) throws SQLException {
		
//		abreConexao(getDaoRespostaAvulsa(), daoRespostaAvulsa);
		ApoioResposta apoio;
		apoio = getDaoRespostaAvulsa().buscaRespostaAvulsa(idQuestao, chaveUsuario, UtilDate.getDateComoSqlDate(dtSolucao), horarioSolucao);
		fechaConexao(daoRespostaAvulsa);
		return apoio;
	}
	
	public ApoioResposta buscaRespostaAvulsa_Aberta(Integer idQuestao, Integer chaveUsuario, Date dtSolucao, Time horarioSolucao) throws SQLException {
//		abreConexao(getDaoRespostaAvulsa_Aberta(), daoRespostaAvulsa_Aberta);
		ApoioResposta apoio;
		apoio = getDaoRespostaAvulsa_Aberta().buscaRespostaAvulsa(idQuestao, chaveUsuario, UtilDate.getDateComoSqlDate(dtSolucao), horarioSolucao);
		fechaConexao(daoRespostaAvulsa_Aberta);
		return apoio;
	}
	
	public ApoioResposta buscaRespostaLista(Integer idQuestao, Integer chaveUsuario, Date dtSolucao, Time horarioSolucao) throws SQLException {
//		abreConexao(getDaoRespostaLista(), daoRespostaLista);
		ApoioResposta apoio;
		apoio = getDaoRespostaLista().buscaRespostaLista(idQuestao, chaveUsuario, UtilDate.getDateComoSqlDate(dtSolucao), horarioSolucao);
		fechaConexao(daoRespostaLista);
		return apoio;
	}
	
	public ApoioResposta buscaRespostaLista_Aberta(Integer idQuestao, Integer chaveUsuario, Integer idLista) throws SQLException {
//		abreConexao(getDaoRespostaLista_Aberta(), daoRespostaLista_Aberta);
		ApoioResposta apoio;
		apoio = getDaoRespostaLista_Aberta().buscaRespostaLista(idQuestao, chaveUsuario, idLista);
		fechaConexao(daoRespostaLista_Aberta);
		return apoio;
	}
	
	public Collection buscaRespostasListaDoUsuario(Integer chaveUsuario, String idLista, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException {
		Collection result;
//		abreConexao(getDaoRespostaLista(), daoRespostaLista);
		result = getDaoRespostaLista().buscaRespostasListaDoUsuario(chaveUsuario,idLista,idDisciplina,idConteudo,ano,semestre);
		fechaConexao(daoRespostaLista);
		return result;
	}
	
	public Collection buscaRespostasAbertaListaDoUsuario(Integer chaveUsuario, String idLista, String idDisciplina, String idConteudo, String ano, String semestre) throws SQLException, ParseException {
		Collection result;
//		abreConexao(getDaoRespostaLista(), daoRespostaLista);
		result = getDaoRespostaLista().buscaRespostasAbertaListaDoUsuario(chaveUsuario,idLista,idDisciplina,idConteudo,ano,semestre);
		fechaConexao(daoRespostaLista);
		return result;
	}

	public void excluirResposta(Integer idQuestao, Integer chavePessoa, Date dtSolucao, Date horarioSolucao) throws SQLException {
//		abreConexao(getDaoRespostaAvulsa(), daoRespostaAvulsa);
		getDaoRespostaAvulsa().excluirResposta(idQuestao ,chavePessoa, UtilDate.getDateComoSqlDate(dtSolucao), UtilDate.getDateComoSqlTime(horarioSolucao));
		fechaConexao(daoRespostaAvulsa);
	}
	
	public void corrigirRespostaAvulsa(String correcao, Integer idQuestao, Integer chavePessoa, Date dtSolucao, Date horarioSolucao) throws SQLException {
//		abreConexao(getDaoRespostaAvulsa_Aberta(), daoRespostaAvulsa_Aberta);
		getDaoRespostaAvulsa_Aberta().corrigirResposta(correcao,idQuestao ,chavePessoa, UtilDate.getDateComoSqlDate(dtSolucao), UtilDate.getDateComoSqlTime(horarioSolucao));
		fechaConexao(daoRespostaAvulsa_Aberta);
	}
	
	public void excluirRespostaLista(Integer idQuestao, Integer chavePessoa, Date dtSolucao, Date horarioSolucao) throws SQLException {
//		abreConexao(getDaoRespostaLista(), daoRespostaLista);
		getDaoRespostaLista().excluirResposta(idQuestao ,chavePessoa, UtilDate.getDateComoSqlDate(dtSolucao), UtilDate.getDateComoSqlTime(horarioSolucao));
		fechaConexao(daoRespostaLista);
	}
	
	public void corrigirRespostaLista(String correcao, Integer idQuestao, Integer chavePessoa, Integer idLista) throws SQLException {
//		abreConexao(getDaoRespostaLista_Aberta(), daoRespostaLista_Aberta);
		getDaoRespostaLista_Aberta().corrigirResposta(correcao, idQuestao ,chavePessoa, idLista);
		fechaConexao(daoRespostaLista_Aberta);
	}
	
	
	
	
	
	
	public RespostaAlunoAvulsaDAO getDaoRespostaAvulsa() throws SQLException {
//		if (this.daoRespostaAvulsa == null)
			try {
				this.daoRespostaAvulsa = (RespostaAlunoAvulsaDAO) DAOFactory.getInstance().getDAO("questao.dao.RespostaAlunoAvulsaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoRespostaAvulsa;
	}
	
	public RespostaAlunoListaDAO getDaoRespostaLista() throws SQLException {
//		if (this.daoRespostaLista == null)
			try {
				this.daoRespostaLista = (RespostaAlunoListaDAO) DAOFactory.getInstance().getDAO("questao.dao.RespostaAlunoListaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoRespostaLista;
	}
	
	public RespostaAlunoAvulsa_AbertaDAO getDaoRespostaAvulsa_Aberta() throws SQLException {
//		if (this.daoRespostaAvulsa_Aberta == null)
			try {
				this.daoRespostaAvulsa_Aberta = (RespostaAlunoAvulsa_AbertaDAO) DAOFactory.getInstance().getDAO("questao.dao.RespostaAlunoAvulsa_AbertaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoRespostaAvulsa_Aberta;
	}
	
	public RespostaAlunoLista_AbertaDAO getDaoRespostaLista_Aberta() throws SQLException {
//		if (this.daoRespostaLista_Aberta == null)
			try {
				this.daoRespostaLista_Aberta = (RespostaAlunoLista_AbertaDAO) DAOFactory.getInstance().getDAO("questao.dao.RespostaAlunoLista_AbertaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoRespostaLista_Aberta;
	}
	
}