/*
 * Created on 30/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.slave;

import java.text.ParseException;
import java.util.Date;

import questao.visao.VisaoQuestao;


/**
 * @author daniel.freitas
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DominioSemestre {
	
	public static final String SEMESTRE1="1";  
	public static final String SEMESTRE2="2";  
	
	public static Date getValorDataMinimoPorSemestre(String semestre, String ano) throws ParseException{
		String dataMinima = null;
		
		if(VisaoQuestao.isStringVazia(semestre))
			return getValorDataMinimaPorAno(ano);
		
		
		if(semestre.equals(SEMESTRE1))
			dataMinima = "01/01/";
		else
			dataMinima = "01/07/";
		dataMinima=configuraDataComAno(dataMinima,ano);
		
		return UtilDate.getData(dataMinima);
	}
	
	private static Date getValorDataMinimaPorAno(String ano) throws ParseException {
		return UtilDate.getData("01/01/"+ano);
	}

	public static Date getValorDataMaximoPorSemestre(String semestre, String ano) throws ParseException{
		String dataMaxima = null;
		
		if(VisaoQuestao.isStringVazia(semestre))
			return getValorDataMaximaPorAno(ano);
		
		
		if(semestre.equals(SEMESTRE1))
			dataMaxima="30/06/";
		else
			dataMaxima="31/12/";
		dataMaxima=configuraDataComAno(dataMaxima,ano);
		
		return UtilDate.getData(dataMaxima);
	}
	
	private static Date getValorDataMaximaPorAno(String ano) throws ParseException {
		return UtilDate.getData("31/12/"+ano);
	}

	private static String configuraDataComAno(String dataSemAno, String ano) {
		String dataMaxima;
		if(VisaoQuestao.isStringVazia(ano))
			dataMaxima = dataSemAno+UtilDate.getAnoAtual();
		else
			dataMaxima = dataSemAno+ano;
		return dataMaxima;
	}

	public static String getValorSemestrePelaData(Date data) throws ParseException{
		if(UtilDate.getMes(data)>0 && UtilDate.getMes(data)<7){
			return SEMESTRE1;
		}
		return SEMESTRE2;
	}
}
