/*
 * Created on 08/03/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.slave;

import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import slave.Dominio;
import dto.DiretorDTO;
import dto.PessoaDTO;

/**
 * @author daniel.freitas
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ElementoPerfilDiretor extends ElementoStrategy {
	private Integer perfil;
	private PessoaDTO pessoa;
	private HttpSession secao;
	
	public ElementoPerfilDiretor(Integer perfil, PessoaDTO pessoa, HttpSession secao){
		setPerfil(perfil);
		setPessoa(pessoa);
		setSecao(secao);
	}
	
	public Integer getPerfil() {
		return this.perfil;
	}
	public void setPerfil(Integer perfil) {
		this.perfil = perfil;
	}
	public PessoaDTO getPessoa() {
		return this.pessoa;
	}
	public void setPessoa(PessoaDTO pessoa) {
		this.pessoa = pessoa;
	}
	public HttpSession getSecao() {
		return this.secao;
	}
	public void setSecao(HttpSession secao) {
		this.secao = secao;
	}
	
	public boolean condicao() throws SQLException {
		return getPerfil().intValue()==Dominio.getDiretor().intValue();
	}

	public void executa() throws SQLException {
		DiretorDTO diretor = new DiretorDTO();
		diretor = (DiretorDTO)getSecao().getAttribute("diretor");
		putDadosPessoa(diretor);
	}
	
	private void putDadosPessoa(DiretorDTO diretor) {
		getPessoa().setChavePessoa(diretor.getChavePessoa());
		getPessoa().setApelido(diretor.getApelido());
		getPessoa().setCpf(diretor.getCpf());
		getPessoa().setDtNascer(diretor.getDtNascer());
		getPessoa().setEmail(diretor.getEmail());
		getPessoa().setNomePessoa(diretor.getNomePessoa());
		getPessoa().setSexo(diretor.getSexo());
		getPessoa().setSituacao(diretor.getSituacao());
		getPessoa().setWebPessoal(diretor.getWebPessoal());
	}
	
}

