package questao.slave;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UtilReflexao {

            /**

             * chama o mtodo set para o atributo nomeDoAtributo em objeto. O tipo do atributo 

             * determinado pelo mtodo get no objeto.

             * 

             * @param objeto

             * @param nomeDoAtributo

             * @param parametro

             */

            public static void setValorDoAtributo(Object objeto, String nomeDoAtributo, Object parametro) {


                        Object[] parametros = new Object[] { parametro };

 

                        String nomeDoSet = getNomeDoMetodoSet(nomeDoAtributo);

                        Class tiposDeParametros[];

                        Class classe = objeto.getClass();

                        try {

                                    Class classeDoParametro = getTipoDeRetornoDoMetodo(nomeDoAtributo, classe);

                                    tiposDeParametros = new Class[] { classeDoParametro };

                                    classe.getMethod(nomeDoSet, tiposDeParametros).invoke(objeto, parametros);

                        } catch (Exception ex) {

                                    throw new RuntimeException(ex);

                        }

            }

 

            /**

             * @param nomeDoMetodo

             * @param classe

             * @return
             * @throws Exception

             */

            protected static Class getTipoDeRetornoDoMetodo(String nomeDoMetodo, Class classe) throws Exception {

                        try {

                                    return classe.getMethod(getNomeDoMetodoGet(nomeDoMetodo), null).getReturnType();

                        } catch (SecurityException e) {

                            throw new Exception(e); 

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

 

            /**

             * chama o mtodo set para o atributo nomeDoAtributo em objeto. O tipo do atributo 

             * tipoDoAtributo

             * 

             * @param receptor

             * @param nomeDoAtributo

             * @param parametro

             * @param tipoDoAtributo
             * @throws Exception

             */

            public static void setValorDoAtributo(

                        Object receptor,

                        String nomeDoAtributo,

                        Object parametro,

                        Class tipoDoAtributo) throws Exception {

 

                        Method metodo;

                        metodo = getMetodoSet(receptor, nomeDoAtributo, tipoDoAtributo);

 

                        invocaMetodoSet(receptor, parametro, metodo);

 

            }

 

            /**

             * @param receptor

             * @param parametro

             * @param metodo
             * @throws Exception

             */

            public static void invocaMetodoSet(Object receptor, Object parametro, Method metodo) throws Exception {

                        try {

                                    metodo.invoke(receptor, new Object[] { parametro });

                        } catch (IllegalArgumentException e) {

                            throw new Exception(e);

                        } catch (IllegalAccessException e) {

                                    throw new Exception(e);

                        } catch (InvocationTargetException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Object getValorDoAtributo(Object objeto, String nomeDoAtributo) {

                        String nomeDoGet = getNomeDoMetodoGet(nomeDoAtributo);

                        try {

                                    return objeto.getClass().getMethod(nomeDoGet, null).invoke(objeto, null);

                        } catch (Exception ex) {

                                    throw new RuntimeException(ex);

                        }

            }

            

            public static Object getValorDoAtributoComPosicao(Object objeto, String nomeDoAtributo, int posicao) throws Exception {

                        Method metodo = getMetodoGetComPosicao(objeto, nomeDoAtributo);

                        try {

                                    return invocaMetodoGetComPosicao(nomeDoAtributo, posicao, metodo);

                        } catch (Exception ex) {

                                    throw new RuntimeException(ex);

                        }

            }

 

            public static String getNomeDoMetodoGet(String nomeDoAtributo) {

                        return "get" + getStringComPrimeiraLetraMaiuscula(nomeDoAtributo);

            }

 

            /**
			 * @param nomeDoAtributo
			 * @return
			 */
			private static String getStringComPrimeiraLetraMaiuscula(String nomeDoAtributo) {
				return nomeDoAtributo.substring(0,1).toUpperCase()+nomeDoAtributo.substring(1);
			}



			protected static String getNomeDoMetodoSet(String nomeDoAtributo) {

                        return "set" + getStringComPrimeiraLetraMaiuscula(nomeDoAtributo);

            }

 

            public static Class getClasseDoAtributo(Object objeto, String nomeDoAtributo) {

                        try {

                                    String nomeDoMetodoGet = getNomeDoMetodoGet(nomeDoAtributo);

                                    Class classeDoObjeto = objeto.getClass();

                                    Method metodoGet = classeDoObjeto.getMethod(nomeDoMetodoGet, null);

                                    if (metodoGet == null) {

                                                return classeDoObjeto.getField(nomeDoAtributo).getClass();

                                    } else {

                                                return metodoGet.getReturnType();

                                    }

                        } catch (Exception ex) {

                                    throw new RuntimeException(ex);

                        }

            }

            public static Object getObjetoDaClasse(Class classe) throws Exception {

                        try {

                                    return classe.newInstance();

                        } catch (InstantiationException e) {

                            throw new Exception(e);

                        } catch (IllegalAccessException e) {

                            throw new Exception(e);

                        }

            }

            public static void setValorDoAtributo(

                        Object receptor,

                        String nomeDoAtributo,

                        Object valor,

                        int posicao,

                        Class tipoDoAtributo) throws Exception {

                        Method metodo;

 

                        metodo = getMetodoSetComPosicao(receptor, nomeDoAtributo, tipoDoAtributo);

 

                        invocaMetodoSetComPosicao(receptor, valor, posicao, metodo);

 

            }

            /**

             * @param receptor

             * @param valor

             * @param posicao

             * @param metodo
             * @throws Exception

             */

            public static void invocaMetodoSetComPosicao(

                        Object receptor,

                        Object valor,

                        int posicao,

                        Method metodo) throws Exception {

                        try {

                                    metodo.invoke(receptor, new Object[] { valor, new Integer(posicao)});

                        } catch (IllegalArgumentException e) {

                            throw new Exception(e);

                        } catch (IllegalAccessException e) {

                            throw new Exception(e);

                        } catch (InvocationTargetException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Method getMetodoSetComPosicao(

                        Object receptor,

                        String nomeDoAtributo,

                        Class tipoDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo =

                                                receptor.getClass().getMethod(

                                                            getNomeDoMetodoSet(nomeDoAtributo),

                                                            new Class[] { tipoDoAtributo, int.class });

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

            public static Method getMetodoGetComPosicao(Object receptor, String nomeDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo = getMetodoGetComParametros(receptor, nomeDoAtributo, new Class[] { int.class });

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        }

            }

            public static Method getMetodoSet(

                        Object receptor,

                        String nomeDoAtributo,

                        Class tipoDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo =

                                                receptor.getClass().getMethod(

                                                            getNomeDoMetodoSet(nomeDoAtributo),

                                                            new Class[] { tipoDoAtributo });

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

            

            

            public static Method getMetodo(

                                    Object receptor,

                                    String nomeDoMetodo,

                                    Class tipoDoAtributo) throws Exception {

                                    Method metodo;

                                    try {

                                                metodo =

                                                            receptor.getClass().getMethod(

                                                                        nomeDoMetodo,

                                                                        new Class[] { tipoDoAtributo });

                                                return metodo;

                                    } catch (SecurityException e) {

                                        throw new Exception(e);

                                    } catch (NoSuchMethodException e) {

                                        throw new Exception(e);

                                    }

                        }

            

            

            

            public static Method getMetodoGet(Object receptor, String nomeDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo = receptor.getClass().getMethod(getNomeDoMetodoGet(nomeDoAtributo), null);

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Object getValorDoAtributo(

                        Object objeto,

                        String nomeDoAtributo,

                        Class[] parametro,

                        Object[] valorDoParametro) throws Exception {

                        String nomeDoGet = getNomeDoMetodoGet(nomeDoAtributo);

                        try {

                                    return objeto.getClass().getMethod(nomeDoGet, parametro).invoke(

                                                objeto,

                                                valorDoParametro);

                        } catch (Exception ex) {

                            throw new Exception(ex);

                        }

            }

 

            public static Object invocaMetodoGetComPosicao(Object receptor, int posicao, Method metodo) throws Exception {

                        try {

                                    return invocaMetodoGetComParametros(

                                                receptor,

                                                metodo,

                                                new Object[] { new Integer(posicao)});

                        } catch (IllegalArgumentException e) {

                            throw new Exception(e);

                        }

            }

            public static Object invocaMetodoGet(Object receptor, Method metodo) throws Exception {

                        try {

                                    return metodo.invoke(receptor, null);

                        } catch (IllegalArgumentException e) {

                                    throw new Exception(e);

                        } catch (IllegalAccessException e) {

                            throw new Exception(e);

                        } catch (InvocationTargetException e) {

                            throw new Exception(e);

                        }

            }

            public static Object invocaMetodoGetComParametros(

                        Object receptor,

                        Method metodo,

                        Object[] parametros) throws Exception {

                        try {

                                    return metodo.invoke(receptor, parametros);

                        } catch (IllegalArgumentException e) {

                            throw new Exception(e);

                        } catch (IllegalAccessException e) {

                            throw new Exception(e);

                        } catch (InvocationTargetException e) {

                            throw new Exception(e);

                        }

            }

            public static Object getInstanciaDaClasse(String nomeDaClasse) throws Exception {

                        try {

                                    Class classe = Class.forName(nomeDaClasse);

                                    return getInstanciaDaClasse(classe);

                        } catch (ClassNotFoundException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Object getInstanciaDaClasse(Class classe) throws Exception {

                        try {

                                    return classe.newInstance();

                        } catch (InstantiationException e) {

                            throw new Exception(e);

                        } catch (IllegalAccessException e) {

                            throw new Exception(e);

                        }

            }

 

            /**

             * @param classeMetodo

             * @param nomeDoAtributo

             * @return
             * @throws Exception

             */

            public static Method getMetodoGetEstatico(Class classeMetodo, String nomeDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo = classeMetodo.getMethod(getNomeDoMetodoGet(nomeDoAtributo), null);

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        } catch (Exception e) {

                            throw new Exception(e);

                        }

            }

 

            public static Method getMetodoGetComParametros(

                        Object receptor,

                        String nomeDoAtributo,

                        Class[] classes) throws Exception {

                        Method metodo;

                        try {

                                    metodo = receptor.getClass().getMethod(getNomeDoMetodoGet(nomeDoAtributo), classes);

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Method getMetodoGet(Class classe, String nomeDoAtributo) throws Exception {

                        try {

                                    return classe.getMethod(getNomeDoMetodoGet(nomeDoAtributo), null);

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Method getMetodoGetComParametros(

                        Class classe,

                        String nomeDoAtributo,

                        Class[] parametros) throws Exception {

                        try {

                                    return classe.getMethod(getNomeDoMetodoGet(nomeDoAtributo), parametros);

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Method getMetodoGetComPosicao(Class classe, String nomeDoAtributo) throws Exception {

                        return getMetodoGetComParametros(classe, nomeDoAtributo, new Class[] { int.class });

            }

 

            public static Method getMetodoSet(Class classe, String nomeDoAtributo, Class tipoDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo =

                                                classe.getMethod(

                                                            getNomeDoMetodoSet(nomeDoAtributo),

                                                            new Class[] { tipoDoAtributo });

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

 

            public static Method getMetodoSetComPosicao(

                        Class classe,

                        String nomeDoAtributo,

                        Class tipoDoAtributo) throws Exception {

                        Method metodo;

                        try {

                                    metodo =

                                                classe.getMethod(

                                                            getNomeDoMetodoSet(nomeDoAtributo),

                                                            new Class[] { tipoDoAtributo, int.class });

                                    return metodo;

                        } catch (SecurityException e) {

                            throw new Exception(e);

                        } catch (NoSuchMethodException e) {

                            throw new Exception(e);

                        }

            }

            

            public static Method getMetodoSemParametros(Class classe, String nomeDoMetodo) throws Exception {

                try {

            return classe.getMethod(nomeDoMetodo, null);

        } catch (SecurityException e) {

            throw new Exception(e);

        } catch (NoSuchMethodException e) {

            throw new Exception(e);

        }

            }

            

            public static void invocaMetodoSemParametros(Object receptor, Method metodo) throws Exception {

                try {

            metodo.invoke(receptor, null);

        } catch (IllegalArgumentException e) {

            throw new Exception(e);

        } catch (IllegalAccessException e) {

            throw new Exception(e);

        } catch (InvocationTargetException e) {

            throw new Exception(e);

        }

            }

}

