package questao.validacao;

import javax.servlet.http.HttpServletRequest;

import questao.slave.DominioRelatorio;
import questao.validacao.apoio.ApoioRelatorio;
import questao.validacao.message.MessageErrorRelatorio;

public class ValidacaoCamposRelatorio {
	
	public static void validaRelatorio(HttpServletRequest req,MessageErrorRelatorio meq) throws Exception{
		boolean erro = false;
		String pesquisaPor = req.getParameter("pesquisaPor");
		try {
			if(pesquisaPor.equalsIgnoreCase("")){
				throw new Exception();
			}
		}catch (Exception e) {
			meq.setMessagemErroProcuraPor("Informe o tipo de pesquisao");
			erro = true;
		}
		
		if(pesquisaPor.equals(DominioRelatorio.ALUNO)){
			try {
				if(req.getParameter("chaveAluno").equalsIgnoreCase("")){
					throw new Exception();
				}
			}catch (Exception e) {
				meq.setMessagemErroChaveAluno("Aluno Invlido");
				erro = true;
			}
			try {
				if(req.getParameter("idDisciplina").equalsIgnoreCase("")){
					throw new Exception();
				}
			}catch (Exception e) {
				meq.setMessagemErroIdDisciplina("Disciplina Invlida");
				erro = true;
			}
		}
		
		if(pesquisaPor.equals(DominioRelatorio.TURMA)){
			try {
				if(req.getParameter("codigoTurma").equalsIgnoreCase("")){
					throw new Exception();
				}
			}catch (Exception e) {
				meq.setMessagemErroCodigoTurma("Turma Invlida");
				erro = true;
			}
		}
		
		if(pesquisaPor.equals(DominioRelatorio.DISCIPLINA)){
			try {
				if(req.getParameter("idDisciplina").equalsIgnoreCase("")){
					throw new Exception();
				}
			}catch (Exception e) {
				meq.setMessagemErroIdDisciplina("Disciplina Invlida");
				erro = true;
			}
		}
		
		if(erro == true){
			loadRelatorioApoio(req);
			throw new Exception();
		}
	}
	private static void loadRelatorioApoio(HttpServletRequest req){
		ApoioRelatorio aq = new ApoioRelatorio();
		aq.setProcuraPor(req.getParameter("pesquisaPor"));
		aq.setChaveAluno(req.getParameter("chaveAluno"));
		aq.setNomeAluno(req.getParameter("nomeAluno"));
		aq.setCodigoTurma(req.getParameter("codigoTurma"));
		aq.setCodigoCurso(req.getParameter("codigoCurso"));
		aq.setIdDisciplina(req.getParameter("idDisciplina"));
		aq.setAno(req.getParameter("ano"));
		aq.setSemestre(req.getParameter("semestre"));
		req.setAttribute("apoio",aq);
	}
}
