package questao.validacao;

import javax.servlet.http.HttpServletRequest;

import questao.slave.UtilDate;
import questao.validacao.apoio.ApoioVincularLista;
import questao.validacao.message.MessageErrorVincularLista;

public class ValidacaoCamposVincularLista {
	
	public static void validaLista(HttpServletRequest req,MessageErrorVincularLista meq) throws Exception{
		boolean erro = false;
		
		try {
			if(req.getParameter("idLista").equalsIgnoreCase("")){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			meq.setMessagemErroLista("Lista Invlida");
			erro = true;
		}
		
		try {//
			if( req.getParameter("codigoTurma").equalsIgnoreCase("") || req.getParameter("codigoCurso").equalsIgnoreCase("") || req.getParameter("idDisciplina").equalsIgnoreCase("") || req.getParameter("ano").equalsIgnoreCase("") || req.getParameter("semestre").equalsIgnoreCase("") ){
				throw new Exception();
			}
		}catch (Exception e) {
			meq.setMessagemErroTurma("Selecione uma turma");
			erro = true;
		}
			
		
		try {
				UtilDate.getData(req.getParameter("dtLimiteEntrega"));
		}catch (Exception e) {
			meq.setMessagemErroData("Data Invlida");
			erro = true;
		}
		
		try {
			String horarioLimiteEntrega = req.getParameter("dtLimiteEntrega")+" "+req.getParameter("horarioLimiteEntrega");
			UtilDate.getDataHora24(horarioLimiteEntrega);
		}catch (Exception e) {
			meq.setMessagemErroHorario("Horario Invlida");
			erro = true;
		}
				
		if(erro == true){
			loadQuestaoApoio(req);
			throw new Exception();
		}
	}
	private static void loadQuestaoApoio(HttpServletRequest req){
		ApoioVincularLista aq = new ApoioVincularLista();
		aq.setIdLista(req.getParameter("idLista"));
		aq.setTituloLista(req.getParameter("tituloLista"));
		aq.setCodigoTurma(req.getParameter("codigoTurma"));
		aq.setCodigoCurso(req.getParameter("codigoCurso"));
		aq.setIdDisciplina(req.getParameter("idDisciplina"));
		aq.setAno(req.getParameter("ano"));
		aq.setSemestre(req.getParameter("semestre"));
		aq.setDataLimite(req.getParameter("dtLimiteEntrega"));
		aq.setHorarioLimite(req.getParameter("horarioLimiteEntrega"));
		req.setAttribute("apoio",aq);
	}
}
