/*
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.visao;

import java.sql.SQLException;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import questao.dto.ComplementoAbertaDTO;
import questao.dto.ComplementoEscolhaDTO;
import questao.dto.ComplementoLacunaDTO;
import questao.dto.ComplementoMultiplaDTO;
import questao.dto.ComplementoVouFDTO;
import questao.dto.QuestaoDTO;
import questao.model.QuestaoModel;
import questao.model.RespostaModel;
import questao.slave.DominioCategoriaQuestao;
import questao.slave.DominioDificuldadeQuestao;
import questao.slave.DominioGabaritoQuestao;
import questao.slave.DominioListaOuQuestao;
import questao.slave.DominioTipoQuestao;
import questao.slave.UtilDate;
import questao.slave.UtilReflexao;
import questao.validacao.apoio.ApoioResposta;
import slave.Dominio;
import dto.AdministradorDTO;
import dto.AlunoDTO;
import dto.DiretorDTO;
import dto.LoginDTO;
import dto.MonitorDTO;
import dto.PessoaDTO;
import dto.ProfessorDTO;

/**
 * @author daniel.freitas
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class VisaoQuestao {
	private List listaQuestoes;
	private QuestaoDTO questao;
	
	public ComplementoVouFDTO buscaComplementoVouF(QuestaoDTO dto,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoVouF(dto.getIdQuestao()); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoVouFDTO buscaComplementoVouF(Integer id,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoVouF(id); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoMultiplaDTO buscaComplementoMultipla(QuestaoDTO dto,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoMultipla(dto.getIdQuestao()); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoMultiplaDTO buscaComplementoMultipla(Integer id,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoMultipla(id); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	public ComplementoEscolhaDTO buscaComplementoEscolha(QuestaoDTO dto,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoEscolha(dto.getIdQuestao()); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoEscolhaDTO buscaComplementoEscolha(Integer id,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoEscolha(id); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoLacunaDTO buscaComplementoLacuna(QuestaoDTO dto,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoLacuna(dto.getIdQuestao()); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoLacunaDTO buscaComplementoLacuna(Integer id,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoLacuna(id); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoAbertaDTO buscaComplementoAberta(QuestaoDTO dto,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoAberta(dto.getIdQuestao()); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ComplementoAbertaDTO buscaComplementoAberta(Integer id,HttpServletRequest req){
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		QuestaoModel model = new QuestaoModel(login);
		try {
			return model.buscaComplementoAberta(id); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 
	}
	
	public ApoioResposta buscaRespostaAberta(String idQuestao,String chavePessoa,String dtSolucao,String horarioSolucao,String listaOuQuestao,HttpServletRequest req){
		ApoioResposta respostaTemp = null;
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		RespostaModel model = new RespostaModel(login);
		Integer idQuestaoTemp = new Integer(idQuestao);
		Integer chavePessoaTemp = new Integer(chavePessoa);
		Date dtSolucaoTemp=UtilDate.getDataAtual();  //Evitar erro
		try {
			if(dtSolucao!=null && !dtSolucao.trim().equals(""))
				dtSolucaoTemp = UtilDate.getData(dtSolucao);
		} catch (ParseException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		Time horarioSolucaoTemp = UtilDate.getDateComoSqlTime(UtilDate.getDataAtual()); //Evitar erro
		try {
			if(horarioSolucao!=null && !horarioSolucao.trim().equals(""))
				horarioSolucaoTemp = UtilDate.getDateComoSqlTime(UtilDate.getDataHora24(dtSolucao+" "+horarioSolucao));
		} catch (ParseException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		try {
			if(listaOuQuestao.equalsIgnoreCase(DominioListaOuQuestao.LISTA))
				respostaTemp =  model.buscaRespostaLista_Aberta(idQuestaoTemp,chavePessoaTemp,new Integer(req.getParameter("idLista"))); 
			else
				respostaTemp =  model.buscaRespostaAvulsa_Aberta(idQuestaoTemp,chavePessoaTemp,dtSolucaoTemp,horarioSolucaoTemp); 
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return respostaTemp; 
	}

	public List getListaQuestoes() {
		if(this.listaQuestoes==null)
			this.listaQuestoes = new ArrayList();
		return this.listaQuestoes;
	}
	
	public void setListaQuestoes(List listaQuestoes) {
		this.listaQuestoes = listaQuestoes;
	}
	
	
	public QuestaoDTO getQuestao() {
		return this.questao;
	}
	
	public void setQuestao(QuestaoDTO questao) {
		this.questao = questao;
	}
		
	public boolean temQuestoesNaLista(){
		return getListaQuestoes().size()>0;
	}
	
	public String getCamposHiddens(HttpServletRequest req){
		StringBuffer retorno = new StringBuffer();
		retorno.append("<input type='hidden' name='idQuestao' value='"+req.getParameter("idQuestao")+"'>");
		retorno.append("<input type='hidden' name='tituloLista' value='"+req.getParameter("tituloLista")+"'>");
		if(req.getParameter("categoria")!=null && req.getParameter("categoria").equals("")){
			retorno.append("<input type='hidden' name='categoria' value='"+req.getParameter("categoriaLista")+"'>");
			retorno.append("<input type='hidden' name='categoriaLista' value='"+req.getParameter("categoriaLista")+"'>");
		}else{
			retorno.append("<input type='hidden' name='categoria' value='"+req.getParameter("categoria")+"'>");
			retorno.append("<input type='hidden' name='categoriaLista' value='"+req.getParameter("categoria")+"'>");
		}
		retorno.append("<input type='hidden' name='quantidadeQuestoes' value='"+req.getParameter("quantidadeQuestoes")+"'>");
		retorno.append("<input type='hidden' name='idDisciplina' value='"+req.getParameter("idDisciplina")+"'>");
		retorno.append("<input type='hidden' name='nomeDisciplina' value='"+req.getParameter("nomeDisciplina")+"'>");
		return retorno.toString();
	}
	
	public String getCamposHiddensResponderQuestoes(HttpServletRequest req){
		StringBuffer retorno = new StringBuffer();
		
		String idLista = req.getParameter("idLista");
		if(idLista==null)
			idLista="";
		retorno.append("<input type='hidden' name='idLista' value='"+idLista+"'>");
		
		String idDisciplina = req.getParameter("idDisciplina");
		if(idDisciplina==null)
			idDisciplina="";
		retorno.append("<input type='hidden' name='idDisciplina' value='"+idDisciplina+"'>");
		
		String idConteudo = req.getParameter("idConteudo");
		if(idConteudo==null)
			idConteudo="";
		retorno.append("<input type='hidden' name='idConteudo' value='"+idConteudo+"'>");
		
		String enunciado = req.getParameter("enunciado");
		if(enunciado==null)
			enunciado="";
		retorno.append("<input type='hidden' name='enunciado' value='"+enunciado+"'>");
		
		String tipoQuestao = req.getParameter("tipoQuestao");
		if(tipoQuestao==null)
			tipoQuestao="";
		retorno.append("<input type='hidden' name='tipoQuestao' value='"+tipoQuestao+"'>");
		
		String dificuldade = req.getParameter("dificuldade");
		if(dificuldade==null)
			dificuldade="";
		retorno.append("<input type='hidden' name='dificuldade' value='"+dificuldade+"'>");
		
		String categoria = req.getParameter("categoria");
		if(categoria==null)
			categoria="";
		retorno.append("<input type='hidden' name='categoria' value='"+categoria+"'>");
		
		return retorno.toString();
	}
	
	public String getCamposHiddensListaQuestoes(){
		StringBuffer retorno = new StringBuffer();
		
		for(int i=0; i<getListaQuestoes().size();i++){
			QuestaoDTO questaoTemp = (QuestaoDTO)getListaQuestoes().get(i);
			retorno.append("<input type='hidden' name='idQuestao#"+i+"' value='"+questaoTemp.getIdQuestao()+"'>");
			retorno.append("<input type='hidden' name='idDisciplina#"+i+"' value='"+questaoTemp.getIdDisciplina()+"'>");
			retorno.append("<input type='hidden' name='idConteudo#"+i+"' value='"+questaoTemp.getIdConteudo()+"'>");
			retorno.append("<input type='hidden' name='chavePessoa#"+i+"' value='"+questaoTemp.getChavePessoa()+"'>");
			retorno.append("<input type='hidden' name='enunciado#"+i+"' value='"+questaoTemp.getEnunciado()+"'>");
			retorno.append("<input type='hidden' name='tipoQuestao#"+i+"' value='"+questaoTemp.getTipoQuestao()+"'>");
			retorno.append("<input type='hidden' name='dificuldade#"+i+"' value='"+questaoTemp.getDificuldade()+"'>");
			retorno.append("<input type='hidden' name='categoria#"+i+"' value='"+questaoTemp.getCategoria()+"'>");
			retorno.append("<input type='hidden' name='tempo#"+i+"' value='"+questaoTemp.getTempo()+"'>");
			retorno.append("<input type='hidden' name='dtcriacao#"+i+"' value='"+UtilDate.getDataComoString(questaoTemp.getDtcriacao())+"'>");
		}
		return retorno.toString();
	}
	
	public String getCamposHiddensListaQuestoesEnumeration(HttpServletRequest req){
		StringBuffer retorno = new StringBuffer();
		String nomeCampo = null;
		
		Enumeration enum1 = req.getParameterNames();
		while(enum1.hasMoreElements()){
			nomeCampo = (String)enum1.nextElement();

			if(nomeCampo.lastIndexOf("#")>0){
				retorno.append("<input type='hidden' name='"+nomeCampo+"' value='"+req.getParameter(nomeCampo)+"'>");
			}
		}
		return retorno.toString();
	}
	
	public static List recuperaLista(HttpServletRequest req) throws Exception{
		List retorno = new ArrayList();
		String nomeCampo = null;
		QuestaoDTO questaoTemp = null;
		Enumeration campos = req.getParameterNames();
		int contadorIndiceObjeto = -1;
		
		while(campos.hasMoreElements()){
			nomeCampo = (String)campos.nextElement();
			int posicao = nomeCampo.lastIndexOf("#");
			if(posicao>0){ //Controla se existe o nao o caracter '#' que indica lista
				if(contadorIndiceObjeto<Integer.parseInt(nomeCampo.substring(posicao+1))){  //Significa outro index ou outro objeto
					contadorIndiceObjeto++;
					questaoTemp = recuperaDadosDaQuestao(req,contadorIndiceObjeto);
					testaAdicionaObjetoNaLista(retorno, questaoTemp);
				}
			}
		}
		testaAdicionaObjetoNaLista(retorno, questaoTemp);
		return retorno;
		
	}
	
	private static QuestaoDTO recuperaDadosDaQuestao(HttpServletRequest req, int contadorIndiceObjeto) throws Exception{
		String nomeCampoRecuperado;
		Enumeration camposQuestaoRecuperada = req.getParameterNames();
		QuestaoDTO questaoRecuperada = new QuestaoDTO();
		int indiceObjeto=0;
		int posicaoInterna = 0;
		
		while(camposQuestaoRecuperada.hasMoreElements()){
			nomeCampoRecuperado = (String)camposQuestaoRecuperada.nextElement();
			posicaoInterna = nomeCampoRecuperado.lastIndexOf("#");
			
			if(posicaoInterna>0)
				indiceObjeto = Integer.parseInt(nomeCampoRecuperado.substring(posicaoInterna+1));
			
			if(posicaoInterna>0 && indiceObjeto==contadorIndiceObjeto){  //O 'contadorIndiceObjeto' igual significa que se trata da mesma questao.
				UtilReflexao.setValorDoAtributo(questaoRecuperada, nomeCampoRecuperado.substring(0, posicaoInterna), req.getParameter(nomeCampoRecuperado),String.class);
			}
		}
		return questaoRecuperada;
	}
	
	private static void testaAdicionaObjetoNaLista(List listaQuestoesTemp, QuestaoDTO questaoTemp) {
		if(questaoTemp!=null && !listaQuestoesTemp.contains(questaoTemp)){
			listaQuestoesTemp.add(questaoTemp);
		}
	}
	
	public static String getRadioChecado(String itemFinal, String itemRadio){
		if(itemFinal!=null && itemFinal.lastIndexOf(itemRadio)>-1)
			return "checked";
		return "";
	}
	
	public static String getRadioChecadoMultipla(String itemFinal, Integer itemRadio){
		if(itemFinal!=null && itemFinal.lastIndexOf(itemRadio.toString())>-1)
			return "checked";
		return "";
	}
	
	public static String getRadioChecadoEscolha(String itemFinal, Integer itemRadio){
		if(itemRadio!=null && itemRadio.equals(DominioGabaritoQuestao.VALOR_1)){
			if(itemFinal!=null && ( itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_4) )) {
				return "checked";
			}
		}
		if(itemRadio!=null && itemRadio.equals(DominioGabaritoQuestao.VALOR_2)){
			if(itemFinal!=null && ( itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_4) )) {
				return "checked";
			}
		}
		if(itemRadio!=null && itemRadio.equals(DominioGabaritoQuestao.VALOR_3)){
			if(itemFinal!=null && ( itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_3) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_3_4) )) {
				return "checked";
			}
		}
		if(itemRadio!=null && itemRadio.equals(DominioGabaritoQuestao.VALOR_4)){
			if(itemFinal!=null && ( itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_1_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_2_3_4) || itemFinal.equals(DominioGabaritoQuestao.COD_VALOR_3_4) )) {
				return "checked";
			}
		}
		return "";
	}
	
	public static String getComboSelected(String itemFinal, String itemRadio){
		if(itemFinal!=null && itemFinal.lastIndexOf(itemRadio)>-1)
			return "selected";
		return "";
	}
	
	public static boolean isStringVazia(String texto){
		return texto==null || texto.equalsIgnoreCase("");
	}
	
	public static PessoaDTO carregaPessoaPeloPerfil(HttpSession secao, Integer perfil){
		PessoaDTO pessoa = null;
		if(perfil.intValue() == Dominio.getAdministrador().intValue()){
			AdministradorDTO admin = new AdministradorDTO();
			admin = (AdministradorDTO)secao.getAttribute("administrador");
			pessoa = admin;
		}
	   	if(perfil.intValue() == Dominio.getAluno().intValue()){
			AlunoDTO aluno = new AlunoDTO();
			aluno = (AlunoDTO)secao.getAttribute("aluno");
			pessoa = aluno;
		}
	   	if(perfil.intValue() == Dominio.getDiretor().intValue()){
			DiretorDTO diretor = new DiretorDTO();
			diretor = (DiretorDTO)secao.getAttribute("diretor");
			pessoa = diretor;
		}
	   	if(perfil.intValue() == Dominio.getMonitor().intValue()){
	   		MonitorDTO monitor = new MonitorDTO();
			monitor = (MonitorDTO)secao.getAttribute("monitor");
			pessoa = monitor;
		}
	   	if(perfil.intValue() == Dominio.getProfessor().intValue()){
			ProfessorDTO professor = new ProfessorDTO();
			professor = (ProfessorDTO)secao.getAttribute("professor");
			pessoa = professor;
		}
	   	return pessoa;
	}
	
	public static String formataDuasCasasDecimais(double valor){
        DecimalFormat format = new DecimalFormat();
        format.applyPattern("0.##");
		return format.format(valor).toString();
	}
	
	public static String formataFraseLacuna(String frase){
        String fraseFinal = frase.replaceAll("#", "<input type='text' id='solucaoLacuna' name='solucaoLacuna' value=''>");
		return fraseFinal;
	}
	
	public static String formataFraseLacunaComResposta(String frase, String resposta){
        String fraseFinal = frase.replaceAll("#", "<i>"+resposta+"</i>");
		return fraseFinal;
	}
	
	public static String getDesctricaoTipoQuestao(String tipo){
        String tipoTemp = "";
        if(tipo!=null){
        	if(tipo.equals(DominioTipoQuestao.getValorVouF()))
        		tipoTemp = DominioTipoQuestao.getDescricaoVouF();
        	else if(tipo.equals(DominioTipoQuestao.getValorMultiplaEscolha()))
        		tipoTemp = DominioTipoQuestao.getDescricaoMultiplaEscolha();
        	else if(tipo.equals(DominioTipoQuestao.getValorEscolhaMultipla()))
        		tipoTemp = DominioTipoQuestao.getDescricaoEscolhaMultipla();
        	else if(tipo.equals(DominioTipoQuestao.getValorLacunas()))
        		tipoTemp = DominioTipoQuestao.getDescricaoLacunas();
        	else if(tipo.equals(DominioTipoQuestao.getValorDissertacao()))
        		tipoTemp = DominioTipoQuestao.getDescricaoDissertacao();
        }
		return tipoTemp;
	}
	
	public static String getDesctricaoDificuldade(String dificuldade){
        String dificuldadeTemp = "";
		dificuldadeTemp = DominioDificuldadeQuestao.getNomeDificuldade(dificuldade);
		return dificuldadeTemp;
	}
	
	public static String getDesctricaoCategoria(String categoria){
        String categoriaTemp = "";
		categoriaTemp = DominioCategoriaQuestao.getNomeCategoria(categoria);
		return categoriaTemp;
	}
	
}
