package slave;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.servlet.ServletException;


public class ConectionPool {

	Properties conexoes = new Properties();

	private static ConectionPool ConexoesPool;

	/**
	 * singleton
	 *  
	 */
	private ConectionPool() {
	}

	/**
	 * metodo para implementacao do singleton
	 * 
	 * @return
	 */
	public static ConectionPool getInstance() {
		if (ConexoesPool == null) {
			ConexoesPool = new ConectionPool();
			try {
				ConexoesPool.carregarConexoes("conexoes.properties");
			} catch (ServletException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return ConexoesPool;
	}
	private void carregarConexoes(String arquivo) throws ServletException {
		try {
			if (arquivo == null) {
				throw new ServletException(
						"No foi possivel encontrar no descritor a variavel de inicializacao 'acoes'");
			}
			InputStream str = this.getClass().getClassLoader().getResourceAsStream(arquivo);
			//ResourceBundle rb = ResourceBundle.getBundle("acoes");
			if (str == null) {
				throw new ServletException(
						"No foi possivel encontrar o arquivo de conexao");
			}
			//System.out.println(rb.getString("ola"));
			conexoes.load(str);
		} catch (IOException e) {
			e.printStackTrace();
		}

	}
	public String obter(String chave) {
		return (String) conexoes.get(chave);
	}
}
