package slave;

import java.io.*;
import java.util.Properties;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;


public class ConfiguracaoPool {

	Properties conexoes = new Properties();

	private static ConfiguracaoPool ConexoesPool;

	/**
	 * singleton
	 *  
	 */
	private ConfiguracaoPool() {
	}

	/**
	 * metodo para implementacao do singleton
	 * 
	 * @return
	 */
	public static ConfiguracaoPool getInstance() {
		if (ConexoesPool == null) {
			ConexoesPool = new ConfiguracaoPool();
			try {
				ConexoesPool.carregarConexoes("configuracoes.properties");
			} catch (ServletException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return ConexoesPool;
	}

	private void carregarConexoes(String arquivo) throws ServletException {
		try {
			if (arquivo == null) {
				throw new ServletException(
						"No foi possivel encontrar no descritor a variavel de inicializacao 'acoes'");
			}
			InputStream str = this.getClass().getClassLoader().getResourceAsStream(arquivo);
			//ResourceBundle rb = ResourceBundle.getBundle("acoes");
			if (str == null) {
				throw new ServletException("No foi possivel encontrar o arquivo de conexao");
			}
			//System.out.println(rb.getString("ola"));
			conexoes.load(str);
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	public void setarConexoesArquivo() throws ServletException {
		setarConexoes("configuracoes.properties");
	}

	private void setarConexoes(String arquivo) throws ServletException {
		try {
			if (arquivo == null) {
				throw new ServletException(
						"No foi possivel encontrar no descritor a variavel de inicializacao 'acoes'");
			}
			DataOutputStream out1 = new DataOutputStream(new BufferedOutputStream(
					new FileOutputStream(arquivo)));
			out1.writeChars("teste");
			out1.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	public void addSourcePropertie(HttpServletRequest req, ConfiguracaoPropriedades propriedades) throws FileNotFoundException, IOException {
		ServletContext contexto = req.getSession().getServletContext();
		File arquivo = new File(contexto.getRealPath("/")+"WEB-INF/src/configuracoes.properties");
		conexoes.load(new FileInputStream(arquivo));
		
		conexoes.setProperty("ALT_IMAGEM", propriedades.getALT_IMAGEM());
		conexoes.setProperty("TITLE_IMAGEM", propriedades.getTITLE_IMAGEM());
		conexoes.setProperty("IMAGEM_NAME", propriedades.getIMAGEM_NAME());
		conexoes.store(new FileOutputStream(arquivo), null); 

//		conexoes.store(new FileOutputStream("configuracoes.properties"), "");
	}

	public String obter(String chave) {
		return (String) conexoes.get(chave);
	}
}