package sti.acao;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import slave.Dominio;

import acao.Acao;

public class AbrirContextoSTIAcao implements Acao{
	
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		secao.setAttribute("contexto","STI");
		secao.setAttribute("execucao","Pesquisar");
		Integer perfil = (Integer)secao.getAttribute("perfil");
		if(perfil.intValue()==Dominio.getAdministrador().intValue())
			return "/jsp/sti/administrador/menuSTIAdministrador.jsp";
		else if(perfil.intValue()==Dominio.getAluno().intValue())
			return "/jsp/sti/aluno/menuSTIAluno.jsp";
		else if(perfil.intValue() == Dominio.getProfessor().intValue())
			return "/jsp/sti/professor/menuSTIProfessor.jsp";
		else if(perfil.intValue() == Dominio.getMonitor().intValue())
			return "/jsp/sti/monitor/menuSTIMonitor.jsp";
		else if(perfil.intValue() == Dominio.getDiretor().intValue())
			return "/jsp/sti/diretor/menuSTIDiretor.jsp";
		return "/jsp/questao/aberturaQuestoes.jsp";
	}
}
