package sti.acao.acompanhamento;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;

public class AbrirDisciplinasParaGerarAcompanhamentoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		req.getSession().setAttribute("contexto","Configuraes");
		req.getSession().setAttribute("execucao","Selecionar");
		DisciplinaModel model = new DisciplinaModel(login);
		Collection disciplinas;
		try {
			disciplinas = model.listarTodasDisciplinas();
			req.setAttribute("disciplinas",disciplinas);
		} catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarDisciplina.do";
		}
		return "/jsp/sti/acompanhamento/listaDeTodasDisciplinas.jsp";
	}

}
