package sti.acao.acompanhamento;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.AlunoModel;
import model.CursoModel;
import model.DisciplinaModel;
import model.ProfessorModel;
import slave.Data;
import slave.Dominio;
import sti.model.acompanhamento.AcompanhamentoListasModel;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import acao.Acao;
import dto.AlunoDTO;
import dto.CursoDTO;
import dto.DisciplinaDTO;
import dto.LoginDTO;
import dto.ProfessorDTO;

public class AcompanharTodasListasAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		Integer chavePessoaProfessor = new Integer(req.getParameter("chavePessoaProfessor"));
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		String codigoTurma = req.getParameter("codigoTurma");
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		//Integer idLista = new Integer(req.getParameter("idLista"));
		
		req.setAttribute("codigoCurso",codigoCurso);
		req.setAttribute("idDisciplina",idDisciplina);
		req.setAttribute("codigoTurma",codigoTurma);
		
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		AcompanhamentoListasModel model = new AcompanhamentoListasModel(login);
		STIAcompanhamentoModel modelSTI = new STIAcompanhamentoModel(login);
		AlunoModel alunoModel = new AlunoModel(login);
		ProfessorModel modelProfessor = new ProfessorModel(login);
		CursoModel cursoModel = new CursoModel(login);
		DisciplinaModel modelDisciplina = new DisciplinaModel(login);
		Collection certas = null;
		Collection erradas = null;
		Collection conteudos = null;
		AlunoDTO aluno = null;
		ProfessorDTO professor = null;
		CursoDTO curso = null;
		DisciplinaDTO disciplina = null;
		try {
			curso = cursoModel.buscarCurso(codigoCurso);
			professor = modelProfessor.buscarProfessor(chavePessoaProfessor);
			aluno = alunoModel.buscarAluno(chavePessoa);
			disciplina = modelDisciplina.buscarDisciplina(idDisciplina);
			conteudos = model.buscarConteudosDasQuestoesDasListasFeitasPeloAluno(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre());
			certas = model.buscarAcompanhamentoDasCertas(chavePessoa,idDisciplina,conteudos);
			erradas = model.buscarAcompanhamentoDasErradas(chavePessoa,idDisciplina,conteudos);
//			tanto faz ser as certas ou erradas.
			modelSTI.setFrequencia(certas,chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre());
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		req.setAttribute("mensagemPesquisa","O Aluno no manisfestou, no Sistema, esforo algum...");
		req.setAttribute("aluno",aluno);
		req.setAttribute("disciplina",disciplina);
		req.setAttribute("professor",professor);
		req.setAttribute("curso",curso);
		req.setAttribute("certas",certas);
		req.setAttribute("erradas",erradas);
		
		return "/jsp/sti/acompanhamento/aluno/acompanhamentoDoAlunoLista.jsp";
	}

}
