package sti.acao.acompanhamento;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException;

import slave.Dominio;
import sti.model.acompanhamento.STIAcompanhamentoModel;

import dto.AlunoDTO;
import dto.LoginDTO;

import acao.Acao;

public class GerarAcompanhamentoParaAlunosDaDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIAcompanhamentoModel model = new STIAcompanhamentoModel(login);
		Collection alunos = getAlunosDoForm(req);
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		try{
			model.gerarAcompanhamentoDosAlunos(alunos,idDisciplina);
		}
		catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
		}
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirConfigurarSistema.do";
	}
	private Collection getAlunosDoForm(HttpServletRequest req){
		Enumeration e = req.getParameterNames();
		Collection alunos = new ArrayList();
		AlunoDTO dto;
		while (e.hasMoreElements()) {
			String chavePessoa = (String) e.nextElement();
			if(!chavePessoa.equalsIgnoreCase("idDisciplina")){
				System.out.println("Resgatando da JSP as seguintes chaveAluno: "+chavePessoa);
				dto = new AlunoDTO();
				dto.setChavePessoa(new Integer(chavePessoa));
				alunos.add(dto);
			}
		}
		return alunos;
	}

}
