package sti.acao.acompanhamento;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.DisciplinaModel;
import slave.Dominio;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import acao.Acao;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class ListarAlunosDaDisciplinaSemAcompanhamentoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIAcompanhamentoModel model = new STIAcompanhamentoModel(login);
		DisciplinaModel discModel = new DisciplinaModel(login);

		Collection col;
		DisciplinaDTO dto;
		try{
			dto = discModel.buscarDisciplina(idDisciplina);
			col  = model.buscaAlunosDaDisciplinaSemAcompanhamento(idDisciplina);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirConfigurarSistema.do";
		}
		req.setAttribute("alunos",col);
		req.setAttribute("disciplina",dto);
		if(col.size()<1){
			req.setAttribute("mensagem", "Todos os alunos desta disciplina j possuem acompanhamento!!!");
			req.setAttribute("mensagemPesquisa", "Todos os alunos desta disciplina j possuem acompanhamento!!!");
		}	
		return "/jsp/sti/acompanhamento/aluno/listarAlunosSemAcompanhamento.jsp";
	}

}
