package sti.acao.aluno;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Data;
import slave.Dominio;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import acao.Acao;
import dto.LoginDTO;

public class AbrirTurmasDoAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		req.getSession().setAttribute("contexto","Situao");
		req.getSession().setAttribute("execucao","Pesquisar");
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIAcompanhamentoModel modelAcompanhamento = new STIAcompanhamentoModel(login);
		
		
		Collection turmas = null;
		try{
		 turmas	= modelAcompanhamento.listaTurmasDoAluno(chavePessoa,Data.getAnoSystem(),Data.getSemestreSystem());
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		req.setAttribute("turmasDoAluno",turmas);
		if(req.getParameter("contexto") != null && req.getParameter("contexto").equalsIgnoreCase("ORIENTACAO")){
			req.getSession().setAttribute("contexto","Orientao");
			if((Integer)req.getSession().getAttribute("perfil") == Dominio.getAluno().intValue())
				return "/jsp/mina/chooseTeam.jsp";
			else
				return "/jsp/sti/orientacao/aluno/listarTurmasDoAluno.jsp";
		}
		return "/jsp/sti/acompanhamento/aluno/listarTurmasDoAluno.jsp";
	}

}
