package sti.acao.aluno;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Data;
import slave.Dominio;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import acao.Acao;
import dto.LoginDTO;
import dto.ProfessorDTO;

public class BuscarAlunosdaTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		String codigoTurma = req.getParameter("codigoTurma");
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		req.setAttribute("codigoCurso",codigoCurso);
		req.setAttribute("idDisciplina",idDisciplina);
		req.setAttribute("codigoTurma",codigoTurma);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIAcompanhamentoModel model = new STIAcompanhamentoModel(login);
		Collection col;
		ProfessorDTO dto = new ProfessorDTO();
		try {
			col = model.buscarAlunosDaTurma(codigoTurma,codigoCurso,idDisciplina,Data.getAnoSystem(),new Integer(Data.getSemestreSystem()).toString());
			dto = model.buscarProfessorDaTurma(codigoTurma,codigoCurso,idDisciplina,Data.getAnoSystem(),new Integer(Data.getSemestreSystem()).toString());
			req.setAttribute("alunosDaTurma",col);
			req.setAttribute("professorDaTurma",dto);
			req.setAttribute("codigoTurma",codigoTurma);
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		req.setAttribute("mensagemPesquisa","No h alunos nessa Turma...");
		if(req.getParameter("contexto") != null && req.getParameter("contexto").equalsIgnoreCase("ORIENTACAO")){
			return "/jsp/sti/orientacao/aluno/listarAlunosDaTurma.jsp";
		}else{
			return "/jsp/sti/acompanhamento/aluno/listarAlunosDaTurma.jsp";
		}
		
	}
}
