package sti.acao.aluno;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.ProfessorModel;
import slave.Data;
import slave.Dominio;
import sti.dto.turma.AlunoDaTurmaDTO;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import acao.Acao;
import dto.LoginDTO;
import dto.ProfessorDTO;

public class BuscarListasFeitasPeloAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		req.getSession().setAttribute("contexto","Situao");
		req.getSession().setAttribute("execucao","Pesquisar");
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));//aluno
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		String codigoTurma = req.getParameter("codigoTurma");
		Integer chavePessoaProfessor = new Integer(req.getParameter("chavePessoaProfessor"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIAcompanhamentoModel modelAcompanhamento = new STIAcompanhamentoModel(login);		
		Collection listas = new ArrayList();
		AlunoDaTurmaDTO aluno = new AlunoDaTurmaDTO();
		ProfessorModel modelP = new ProfessorModel(login);
		ProfessorDTO profDTO = new ProfessorDTO();
		try{
			listas = modelAcompanhamento.buscarListasFeitasPeloAluno(chavePessoa, idDisciplina,codigoCurso,codigoTurma,Data.getAnoSystem(),Data.getSemestreSystem());
			req.setAttribute("listas",listas);
			aluno = modelAcompanhamento.buscarALunoDaTurma(codigoTurma,codigoCurso,idDisciplina,Data.getAnoSystem(),Data.getSemestreSystem(),chavePessoa);
			req.setAttribute("aluno",aluno);
			profDTO = modelP.buscarProfessor(chavePessoaProfessor);
			req.setAttribute("professor",profDTO);
			req.setAttribute("mensagemPesquisa", "O alulno no fez nenhuma lista...");
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		return "/jsp/sti/acompanhamento/aluno/listarListasFeitasPeloAluno.jsp";
	}
}
