package sti.acao.aluno;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.AlunoModel;
import slave.Dominio;
import dto.LoginDTO;
import acao.Acao;

public class PesquisarAlunoParaAcompanhamentoAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String nomeAluno = req.getParameter("nomeAluno");
		String matricula = req.getParameter("matricula");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		AlunoModel model = new AlunoModel(login);
		Collection col;
		try{
			col  = model.buscaAlunos(nomeAluno,matricula);
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		req.setAttribute("alunos",col);
		
		if(col.size()<1)
			req.setAttribute("mensagemPesquisa", Dominio.getMensagemNenhumItemEncontrado());
		if(req.getParameter("contexto") != null && req.getParameter("contexto").equalsIgnoreCase("ORIENTACAO")){
			return "/jsp/sti/orientacao/aluno/pesquisarAlunoParaAcompanhamento.jsp";
		}
		return "/jsp/sti/acompanhamento/aluno/pesquisarAlunoParaAcompanhamento.jsp";
	}
}
