package sti.acao.desempenho.tipo;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import slave.Dominio;
import sti.dto.desempenho.tipo.TipoDesempenhoDTO;
import sti.model.desempenho.tipo.STITipoDesempenhoModel;
import acao.Acao;
import dto.LoginDTO;

public class AbrirAlterarExcluirTipoDesempenhoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("contexto","Tipo Desempenho");
		
		
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		dto.setIdTipoDesempenho(new Integer((String)req.getParameter("idTipoDesempenho")));
		STITipoDesempenhoModel model = new STITipoDesempenhoModel(login);
		try {
			dto = model.buscarTipoDesempenho(dto.getIdTipoDesempenho());
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirContextoDoSTI.do";
		}
		req.setAttribute("tipoDesempenho",dto);
		if(req.getParameter("acao").equalsIgnoreCase("EXCLUIR")){
			secao.setAttribute("execucao","Excluir");
			return "/jsp/sti/desempenho/tipo/administrador/excluirTipoDesempenho.jsp";
		}else{
			secao.setAttribute("execucao","Alterar");
			return "/jsp/sti/desempenho/tipo/administrador/alterarTipoDesempenho.jsp";
		}
	}

}
