package sti.acao.desempenho.tipo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.dto.desempenho.tipo.TipoDesempenhoDTO;
import sti.model.desempenho.tipo.STITipoDesempenhoModel;
import acao.Acao;
import dto.LoginDTO;

public class CadastrarTipoDesempenhoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		//*****************VALIDAO DOS DADOS****************************
			String descricaoTipoDesempenho = (String)req.getParameter("descricaoTipoDesempenho");
			String nomeTipoDesempenho = (String)req.getParameter("nomeTipoDesempenho");
			TipoDesempenhoDTO dto = new TipoDesempenhoDTO(nomeTipoDesempenho,descricaoTipoDesempenho);
			if(dto.getDescricaoTipoDesempenho().equalsIgnoreCase("") || dto.getNomeTipoDesempenho().equalsIgnoreCase("")){
				req.setAttribute("mensagem","Favor, Nome e Descrio do Tipo de Desempenho devem ser informados !! ");
				req.setAttribute("tipoDesempenho",dto);
				return "/abrirCadastrarTipoDesempenho.do";
			}
		//****************************************************************
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STITipoDesempenhoModel model = new STITipoDesempenhoModel(login);
		
		try {
			Collection col = new ArrayList();
			model.cadastrarTipoDesempenho(dto);
			col.add(model.getUltimoInserido());
			req.setAttribute("tiposDesempenho",col);
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		
		req.setAttribute("mensagem","Registro Incluido com Sucesso!!!");
		return "/abrirPesquisarTipoDesempenho.do";
	}

}
