package sti.acao.desempenho.tipo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.dto.desempenho.tipo.TipoDesempenhoDTO;
import sti.model.desempenho.tipo.STITipoDesempenhoModel;
import acao.Acao;
import dto.LoginDTO;

public class PesquisarTipoDesempenhoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO((String)req.getParameter("nomeTipoDesempenho"),(String)req.getParameter("descricaoTipoDesempenho"));
		STITipoDesempenhoModel model = new STITipoDesempenhoModel(login);
		Collection col = new ArrayList();
		try {
			col = model.filtraBuscaTipoDescricao(dto);
			req.setAttribute("tiposDesempenho",col);	
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		if(col.size() == 0){
			req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}
		return "/abrirPesquisarTipoDesempenho.do";
	}

}
