package sti.acao.disciplina;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Data;
import slave.Dominio;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import acao.Acao;
import dto.LoginDTO;

public class BuscarTurmasDaDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		STIAcompanhamentoModel modelSTIAcompanhamento = new STIAcompanhamentoModel(login);
		Collection col;
		try{
			col = modelSTIAcompanhamento.buscarTurmasDaDisciplina(idDisciplina,codigoCurso,Data.getAnoSystem(),Data.getSemestreSystem());
		
			req.setAttribute("turmas",col);
			if(col.size()==0)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		if(req.getParameter("contexto") != null && req.getParameter("contexto").equalsIgnoreCase("ORIENTACAO")){
			return "/jsp/sti/orientacao/professor/listarTurmasDaDisciplina.jsp";
		}else{
			return "/jsp/sti/acompanhamento/professor/listarTurmasDaDisciplina.jsp";
		}
		
	}

}
