package sti.acao.monitor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import slave.Data;
import slave.Dominio;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import dto.LoginDTO;
import acao.Acao;

public class AbrirDisciplinasDoMonitorAcao implements Acao {
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIAcompanhamentoModel modelSTIAcompanhamento = new STIAcompanhamentoModel(login);
		Collection col = new ArrayList();
		try{
			col = modelSTIAcompanhamento.listaDisciplinasMonitoradasPeloMonitor(chavePessoa,Data.getAnoSystem(),Data.getSemestreSystem());
			if(col.size()== 0)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			req.setAttribute("disciplinas",col);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		
		HttpSession sessao = req.getSession();
		sessao.setAttribute("execucao","Pesquisar");
		if(req.getParameter("contexto")!=null &&req.getParameter("contexto").equalsIgnoreCase("ORIENTACAO")){
			sessao.setAttribute("contexto","Orientacao");
			return "/jsp/sti/orientacao/monitor/listarDisciplinasDoMonitor.jsp";
		}else{
			sessao.setAttribute("contexto","Situacao");
			return "/jsp/sti/acompanhamento/monitor/listarDisciplinasDoMonitor.jsp";
		}
		
		
		
	}
}
