package sti.acao.orientacao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.AlunoModel;
import model.DisciplinaModel;

import slave.Dominio;
import sti.exceptions.NotFoundDesempenhoEEsforcoNaRegraException;
import sti.model.orientacao.STIOrientacaoModel;
import acao.Acao;
import dto.AlunoDTO;
import dto.DisciplinaDTO;
import dto.LoginDTO;

import sti.dto.orientacao.ApoioViewOrietacao;
import mina.util.Orientation;

public class OrientarAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		Integer chaveAluno = new Integer(req.getParameter("chavePessoa"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIOrientacaoModel model = new STIOrientacaoModel(login);
		Collection orientacoes = new ArrayList();
		AlunoModel modelAluno = new AlunoModel(login);
		DisciplinaModel modelDisciplina = new DisciplinaModel(login);
		DisciplinaDTO disciplina = modelDisciplina.buscarDisciplina(idDisciplina);
		AlunoDTO aluno = modelAluno.buscarAluno(chaveAluno);
		
		try {
			orientacoes = model.orientarAluno(idDisciplina,chaveAluno);
			
		}catch (com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException e) {
			e.printStackTrace();
			req.setAttribute("mensagem","Provavelmente o Administrador no gerou seu 'Acompanhamento' entre em contato com a equipe SAE!!");
			return "/jsp/aviso.jsp";
		}
		catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/jsp/aviso.jsp";
		}
		catch (NotFoundDesempenhoEEsforcoNaRegraException e) {
			System.out.println(e.getMessage());
			req.setAttribute("mensagem","O administrador deve Cadastrar as regras na base...por Favor, Entre em contato!!");
			e.printStackTrace();
			return "/jsp/aviso.jsp";
		}
		req.setAttribute("disciplina",disciplina);
		req.setAttribute("aluno",aluno);
		// MINA trigger
		if(((Integer)req.getSession().getAttribute("perfil") == Dominio.getAluno().intValue())&&(req.getParameter("mina") != null)&&(req.getParameter("mina").equalsIgnoreCase("awake")))
		{
			Iterator iter = orientacoes.iterator();
			Orientation orientation = null;
			Orientation previous = null;
			
			while(iter.hasNext())
			{
				previous = orientation;
				orientation = new Orientation((ApoioViewOrietacao)iter.next());
			}
			req.getSession().setAttribute("student",aluno);
			req.getSession().setAttribute("firstOrientation",orientation);
			req.getSession().setAttribute("secondOrientation",previous);

			return "/jsp/mina/orientation.jsp";
		}
		else
		{
			req.setAttribute("orientacoes",orientacoes);
			return "/jsp/sti/orientacao/orientacaoAluno.jsp";
		}
	}
}
