package sti.acao.orientacao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.AlunoModel;
import model.DisciplinaModel;

import slave.Dominio;
import sti.exceptions.NotFoundOrientacaoException;
import sti.model.orientacao.STIOrientacaoModel;
import acao.Acao;
import dto.AlunoDTO;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class VerOrientacaoDoAlunoAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		Integer chaveAluno = new Integer(req.getParameter("chavePessoa"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		if(login.getPerfil().intValue() == 3 ||login.getPerfil().intValue() == 5){ //se quem estiver logado for professor ou monitor...
			Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
			String codigoTurma = req.getParameter("codigoTurma");
			Integer chavePessoaProfessor = new Integer(req.getParameter("chavePessoaProfessor"));
			req.setAttribute("chavePessoaProfessor",chavePessoaProfessor);
			req.setAttribute("codigoCurso",codigoCurso);
			req.setAttribute("codigoTurma",codigoTurma);
		}
		STIOrientacaoModel model = new STIOrientacaoModel(login);
		AlunoModel modelAluno = new AlunoModel(login);
		AlunoDTO aluno = modelAluno.buscarAluno(chaveAluno);
		DisciplinaModel modelDisciplina = new DisciplinaModel(login);
		DisciplinaDTO disciplina = modelDisciplina.buscarDisciplina(idDisciplina);
		Collection orientacoes = new ArrayList();
		try {
			orientacoes = model.consultarUltimaOrientacaoAluno(idDisciplina,chaveAluno);
			if(orientacoes.size() == 0)
				throw new NotFoundOrientacaoException();
		}catch (NotFoundOrientacaoException e) {
			e.printStackTrace();
			req.setAttribute("mensagemPesquisa","O aluno ainda no pediu orientao ao sistema...");
			req.setAttribute("mensagem","Verifique se este aluno conseguiu exito nas ultimas avaliacoes...");
			req.setAttribute("orientacoes",orientacoes);
			req.setAttribute("disciplina",disciplina);
			req.setAttribute("aluno",aluno);
			return "/jsp/sti/orientacao/orientacaoAluno.jsp";
		} 
		catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/jsp/aviso.jsp";
		}

		req.setAttribute("disciplina",disciplina);
		req.setAttribute("aluno",aluno);
		req.setAttribute("orientacoes",orientacoes);
		return "/jsp/sti/orientacao/orientacaoAluno.jsp";
	}
}
