package sti.acao.regra;

import java.sql.SQLException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mina.model.AnimationModel;
import acao.Acao;
import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import dto.LoginDTO;

public class AbrirAlterarRegraAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer idRegra = new Integer(req.getParameter("idRegra"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		RegraDTO dto = new RegraDTO();
		try {
			dto = model.buscarRegra(idRegra);
			req.setAttribute("regra",dto);
			req.setAttribute("animationList", (new AnimationModel(login)).getAll());
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		System.out.println("------------------"+dto);
		return "/jsp/sti/regra/administrador/alterarRegra.jsp";
	}
}
