package sti.acao.regra;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import dto.LoginDTO;

import acao.Acao;

public class AbrirExcluirRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer idRegra = new Integer(req.getParameter("idRegra"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		RegraDTO dto = new RegraDTO();
		try {
			dto = model.buscarRegra(idRegra);
			req.setAttribute("regra",dto);
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		
		return "/jsp/sti/regra/administrador/excluirRegra.jsp";
	}

}
