package sti.acao.regra;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import sti.model.sugestoes.STISugestoesModel;
import sti.util.regra.UtilRegra;

import acao.Acao;

public class AlterarRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		RegraDTO dto = new RegraDTO();
		RegraDTO temp = new RegraDTO();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		STISugestoesModel modelSug = new STISugestoesModel(login);
		/*Vide comentario da UtilRegra na classe*/
		try {
			UtilRegra.popularRegra(req,dto,true);
		} catch (Exception e) {//essa exececao eh lancada caso nenhuma sugestao seja cadastrada...
				UtilRegra.popularRegra(req,dto,false);
				
				temp = model.buscarRegra(dto.getIdRegra());
				dto.setSugestoes(temp.getSugestoes());
				
				req.setAttribute("sugestoes",modelSug.buscarTodasSugestoes());
				req.setAttribute("regra",dto);
				req.setAttribute("regraAntiga",temp);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados()+"\nEscolha pelo menos uma Sugesto!!");
			return "/jsp/sti/regra/administrador/continuarAlterarRegra.jsp";
		}
		

		try{
			model.alterarRegra(dto);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirAlterarRegra.do";
		}
		Collection regras = new ArrayList();
		try{
			dto = model.buscarRegra(dto.getIdRegra());
			regras.add(dto);
			req.setAttribute("regras",regras);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarRegra.do";
	}
}
