package sti.acao.regra;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import sti.util.regra.UtilRegra;

import acao.Acao;

public class CadastrarRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		RegraDTO dto = new RegraDTO();
		/*Vide comentario da UtilRegra na classe*/
		try {
			UtilRegra.popularRegra(req,dto,true);
		} catch (Exception e) {//essa exececao eh lancada caso nenhuma sugestao seja cadastrada...
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados()+"\nEscolha pelo menos uma Sugesto!!");
			return "/continuarCadastrarRegra.do";
		}
		
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		try{
			model.cadastrarRegra(dto);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirCadastrarRegra.do";
		}
		Collection regras = new ArrayList();
		try{
			dto = model.buscarUltimaRegraInserida();
			regras.add(dto);
			req.setAttribute("regras",regras);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarRegra.do";
	}
}
