package sti.acao.regra;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import acao.Acao;

import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import sti.model.sugestoes.STISugestoesModel;
import sti.util.regra.UtilRegra;
import dto.LoginDTO;

public class ContinuarAlterarRegraAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("contexto","Regras");
		secao.setAttribute("execucao","Escolha Sugestao");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STISugestoesModel model = new STISugestoesModel(login);
		STIRegraModel modelRegra = new STIRegraModel(login);
		RegraDTO dto = new RegraDTO();
		RegraDTO temp = new RegraDTO();
		UtilRegra.popularRegra(req,dto,false);
		try{
			temp = modelRegra.buscarRegra(dto.getIdRegra());
			dto.setSugestoes(temp.getSugestoes());
			req.setAttribute("sugestoes",model.buscarTodasSugestoes());
			req.setAttribute("regra",dto);
			req.setAttribute("regraAntiga",temp);
		}catch(SQLException e){
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirAlterarRegra.do";
		}
		return "/jsp/sti/regra/administrador/continuarAlterarRegra.jsp";
	}
}
