package sti.acao.regra;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import mina.model.AnimationModel;

import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import sti.model.sugestoes.STISugestoesModel;
import acao.Acao;
import dto.LoginDTO;

public class ContinuarCadastrarRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("contexto","Regras");
		secao.setAttribute("execucao","Escolha Sugestao");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STISugestoesModel model = new STISugestoesModel(login);
		STIRegraModel regraModel = new STIRegraModel(login);
		RegraDTO regraDTO = new RegraDTO();
		regraDTO.setEsforco(req.getParameter("esforco"));
		regraDTO.setDesempenho(req.getParameter("desempenho"));
		if(req.getParameter("animation")!=null)
			regraDTO.setAnimation((new AnimationModel((LoginDTO)req.getSession().getAttribute("loginDTO"))).get(new Integer(req.getParameter("animation"))));
		try{
			if (regraModel.verificaExistenciaDaRegraPorEsforcoDesempenho(regraDTO))
				return "/abrirCadastrarRegra.do?erro=true";
			req.setAttribute("sugestoes",model.buscarTodasSugestoes());
		}catch(SQLException e){
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirCadastrarRegra.do";
		}
		return "/jsp/sti/regra/administrador/continuarCadastrarRegras.jsp";
	}

}
