package sti.acao.regra;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.model.regra.STIRegraModel;
import dto.LoginDTO;

import acao.Acao;

public class ExcluirRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer idRegra = new Integer(req.getParameter("idRegra"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		Collection regras = new ArrayList();
		try {

			model.excluirRegra(idRegra);
			regras = model.buscarTodasRegras();
			if(regras.size()==0)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			req.setAttribute("regras",regras);
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarRegra.do";
	}
}
