package sti.acao.regra;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.model.regra.STIRegraModel;
import acao.Acao;
import dto.LoginDTO;

public class PesquisarRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		String sugestao = req.getParameter("sugestao");
		Collection regras = new ArrayList();
		try{
			regras = model.buscarRegrasPorSugestao(sugestao);
			if(regras.size()==0)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			req.setAttribute("regras",regras);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		return "/abrirPesquisarRegra.do";
	}
}
