package sti.acao.regra;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.dto.regra.RegraDTO;
import sti.model.regra.STIRegraModel;
import acao.Acao;
import dto.LoginDTO;

public class VisualizarRegraAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		RegraDTO dto = new RegraDTO();
		/*Vide comentario da UtilRegra na classe*/
		Integer idRegra = new Integer(req.getParameter("idRegra"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STIRegraModel model = new STIRegraModel(login);
		try{
			dto = model.buscarRegra(idRegra);
			req.setAttribute("regra",dto);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarRegra.do";
		}
		return "/abrirVisualizarRegra.do";
	}
}
