package sti.acao.sugestoes;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import slave.Dominio;
import sti.dto.sugestoes.SugestaoDTO;
import sti.model.sugestoes.STISugestoesModel;
import dto.LoginDTO;

import acao.Acao;

public class AbrirExcluirSugestoesAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("contexto","Sugestoes");
		secao.setAttribute("execucao","Excluir");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		SugestaoDTO dtoSugestao = new SugestaoDTO();
		dtoSugestao.setIdSugestao(new Integer((String)req.getAttribute("idSugestao")));
		STISugestoesModel model = new STISugestoesModel(login);
		try {
			dtoSugestao = model.buscarSugestao(dtoSugestao.getIdSugestao());
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirContextoDoSTI.do";
		}
		req.setAttribute("sugestao",dtoSugestao);
		return "/jsp/sti/sugestoes/administrador/excluirSugestoes.jsp";
	}

}
