package sti.acao.sugestoes;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import sti.dto.sugestoes.SugestaoDTO;
import sti.model.sugestoes.STISugestoesModel;

import DominioDiaDaSemana.Dominio;
import acao.Acao;

public class AlterarExcluirSugestaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String acao = req.getParameter("acao");
		SugestaoDTO dto = new SugestaoDTO();
		dto.setIdSugestao(new Integer((String)req.getParameter("idSugestao")));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		STISugestoesModel model = new STISugestoesModel(login);
		
		if(acao.equalsIgnoreCase("EXCLUIR")){
			try {
				model.excluirSugestao(dto.getIdSugestao());
			} catch (Exception e) {
				e.printStackTrace();
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirTelaInicialDoSTI.do";
			}
		}else{
			try {
				dto.setContexto(req.getParameter("subProjeto"));
				dto.setSugestao(req.getParameter("sugestao"));
				//*****************VALIDAO DOS DADOS****************************
				String textAreaSugestao = (String)req.getParameter("sugestao");
				String comboBox = (String)req.getParameter("subProjeto");
				if((textAreaSugestao == null || textAreaSugestao.equals(""))||(comboBox == null || comboBox.equalsIgnoreCase(""))){
					req.setAttribute("mensagem","Favor,Sugesto e Sub - Projeto devem ser Informados !!");
					req.setAttribute("sugestao",dto);
					return "/abrirAlterarExcluirSugestoes.do";
				}
			//****************************************************************
				model.alterarSugestao(dto);
				Collection col = new ArrayList();
				col.add(dto);
				req.setAttribute("sugestoes",col);
				return "/abrirPesquisarSugestoes.do";
			} catch (Exception e) {
				e.printStackTrace();
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirTelaInicialDoSTI.do";
			}
		}
		req.setAttribute("mensagem",slave.Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarSugestoes.do";
	}

}
