package sti.acao.sugestoes;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.dto.sugestoes.SugestaoDTO;
import sti.model.sugestoes.STISugestoesModel;

import dto.LoginDTO;

import acao.Acao;

public class CadastrarSugestoesAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		//*****************VALIDAO DOS DADOS****************************
			String textAreaSugestao = (String)req.getParameter("sugestao");
			String comboBox = (String)req.getParameter("subProjeto");
			if((textAreaSugestao == null || textAreaSugestao.equals(""))||(comboBox == null || comboBox.equalsIgnoreCase(""))){
				req.setAttribute("mensagem","Informe o texto da sugesto e o seu contexto!");
				return "/abrirCadastrarSugestoes.do";
			}
		//****************************************************************
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		SugestaoDTO dtoSugestao = new SugestaoDTO((String)req.getParameter("subProjeto"),(String)req.getParameter("sugestao"));
		STISugestoesModel model = new STISugestoesModel(login);
		try{
			Collection col = new ArrayList();
			model.cadastrarSugestao(dtoSugestao);
			col.add(model.getUltimoInserido());
			req.setAttribute("sugestoes",col);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		
		
		
		
		req.setAttribute("mensagem","Sugesto cadastrada com sucesso!");
		return "/abrirPesquisarSugestoes.do";
	}

}
