package sti.acao.sugestoes;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import slave.Dominio;
import sti.dto.sugestoes.SugestaoDTO;
import sti.model.sugestoes.STISugestoesModel;
import dto.LoginDTO;

import acao.Acao;

public class PesquisarSugestoesAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		SugestaoDTO dtoSugestao = new SugestaoDTO((String)req.getParameter("subProjeto"),(String)req.getParameter("sugestao"));
		STISugestoesModel model = new STISugestoesModel(login);
		Collection col = new ArrayList();
		try {
			col = model.filtraBusca(dtoSugestao);
			req.setAttribute("sugestoes",col);	
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirTelaInicialDoSTI.do";
		}
		if(col.size() == 0){
			req.setAttribute("mensagem","Nenhuma sugesto encontrada no contexto "+dtoSugestao.getContexto()+" com o texto informado.");
		}
		return "/abrirPesquisarSugestoes.do";
	}
}